<?php
// Demo halaman pelanggan selesai instalasi tanpa login
require_once 'config/database.php';

$database = new Database();
$db = $database->getConnection();

// Data sample untuk demo
$demo_customers = [
    [
        'nama_lengkap' => 'Budi Santoso',
        'email' => 'budi.santoso@email.com',
        'nomor_hp' => '081234567892',
        'alamat_instalasi' => 'Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'kabel_meter' => 50,
        'teknisi_name' => 'Teknisi 1',
        'tanggal_instalasi' => date('Y-m-d H:i:s'),
        'catatan' => 'Instalasi berhasil, sinyal kuat'
    ],
    [
        'nama_lengkap' => 'Maya Sari',
        'email' => 'maya.sari@email.com',
        'nomor_hp' => '081234567896',
        'alamat_instalasi' => 'Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'kabel_meter' => 60,
        'teknisi_name' => 'Teknisi 2',
        'tanggal_instalasi' => date('Y-m-d H:i:s', strtotime('-1 day')),
        'catatan' => 'Instalasi selesai, pelanggan puas'
    ],
    [
        'nama_lengkap' => 'Eko Prasetyo',
        'email' => 'eko.prasetyo@email.com',
        'nomor_hp' => '081234567895',
        'alamat_instalasi' => 'Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'kabel_meter' => 40,
        'teknisi_name' => 'Teknisi 2',
        'tanggal_instalasi' => date('Y-m-d H:i:s', strtotime('-3 days')),
        'catatan' => 'Instalasi baru dimulai'
    ],
    [
        'nama_lengkap' => 'Ahmad Wijaya',
        'email' => 'ahmad.wijaya@email.com',
        'nomor_hp' => '081234567890',
        'alamat_instalasi' => 'Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'kabel_meter' => 75,
        'teknisi_name' => 'Teknisi 1',
        'tanggal_instalasi' => date('Y-m-d H:i:s', strtotime('-1 week')),
        'catatan' => 'Instalasi berhasil'
    ],
    [
        'nama_lengkap' => 'Siti Nurhaliza',
        'email' => 'siti.nurhaliza@email.com',
        'nomor_hp' => '081234567891',
        'alamat_instalasi' => 'Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi',
        'kabel_meter' => 55,
        'teknisi_name' => 'Teknisi 1',
        'tanggal_instalasi' => date('Y-m-d H:i:s', strtotime('-2 weeks')),
        'catatan' => 'Instalasi pending, menunggu konfirmasi pelanggan'
    ]
];

// Kategorisasi data
$categories = [
    'today' => [],
    'this_week' => [],
    'this_month' => [],
    'older' => []
];

$today = date('Y-m-d');
$week_start = date('Y-m-d', strtotime('monday this week'));
$month_start = date('Y-m-01');

foreach ($demo_customers as $customer) {
    $install_date = date('Y-m-d', strtotime($customer['tanggal_instalasi']));
    
    if ($install_date == $today) {
        $categories['today'][] = $customer;
    } elseif ($install_date >= $week_start) {
        $categories['this_week'][] = $customer;
    } elseif ($install_date >= $month_start) {
        $categories['this_month'][] = $customer;
    } else {
        $categories['older'][] = $customer;
    }
}

// Statistik
$stats = [
    'total' => count($demo_customers),
    'today' => count($categories['today']),
    'this_week' => count($categories['this_week']),
    'this_month' => count($categories['this_month']),
    'older' => count($categories['older'])
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Pelanggan Selesai Instalasi - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .category-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            border-left: 4px solid;
        }
        .category-card.today { border-left-color: #28a745; }
        .category-card.week { border-left-color: #17a2b8; }
        .category-card.month { border-left-color: #ffc107; }
        .category-card.older { border-left-color: #6c757d; }
        .customer-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
        }
        .customer-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .status-badge {
            font-size: 0.75rem;
        }
        .stats-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            text-align: center;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .stats-card h3 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>📋 Demo - Pelanggan Selesai Instalasi</h3>
            <p class="lead">Data pelanggan yang sudah selesai instalasi, dikategorikan berdasarkan waktu</p>
        </div>
        
        <!-- Statistik -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stats-card">
                    <h3><?php echo $stats['total']; ?></h3>
                    <p class="text-muted mb-0">Total Selesai</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3 class="text-success"><?php echo $stats['today']; ?></h3>
                    <p class="text-muted mb-0">Hari Ini</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3 class="text-info"><?php echo $stats['this_week']; ?></h3>
                    <p class="text-muted mb-0">Minggu Ini</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stats-card">
                    <h3 class="text-warning"><?php echo $stats['this_month']; ?></h3>
                    <p class="text-muted mb-0">Bulan Ini</p>
                </div>
            </div>
        </div>
        
        <!-- Kategori Hari Ini -->
        <?php if (!empty($categories['today'])): ?>
        <div class="category-card today">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="fas fa-calendar-day me-2"></i>Hari Ini
                    <span class="badge bg-success ms-2"><?php echo count($categories['today']); ?></span>
                </h4>
                <small class="text-muted"><?php echo date('d F Y'); ?></small>
            </div>
            <div class="row">
                <?php foreach ($categories['today'] as $customer): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                            <span class="badge bg-success status-badge">Selesai</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-clock me-1"></i><?php echo date('H:i', strtotime($customer['tanggal_instalasi'])); ?>
                        </p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Kategori Minggu Ini -->
        <?php if (!empty($categories['this_week'])): ?>
        <div class="category-card week">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="fas fa-calendar-week me-2"></i>Minggu Ini
                    <span class="badge bg-info ms-2"><?php echo count($categories['this_week']); ?></span>
                </h4>
                <small class="text-muted"><?php echo date('d F Y', strtotime('monday this week')); ?> - <?php echo date('d F Y', strtotime('sunday this week')); ?></small>
            </div>
            <div class="row">
                <?php foreach ($categories['this_week'] as $customer): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                            <span class="badge bg-info status-badge">Selesai</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                        </p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Kategori Bulan Ini -->
        <?php if (!empty($categories['this_month'])): ?>
        <div class="category-card month">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="fas fa-calendar-alt me-2"></i>Bulan Ini
                    <span class="badge bg-warning ms-2"><?php echo count($categories['this_month']); ?></span>
                </h4>
                <small class="text-muted"><?php echo date('F Y'); ?></small>
            </div>
            <div class="row">
                <?php foreach ($categories['this_month'] as $customer): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                            <span class="badge bg-warning status-badge">Selesai</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                        </p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Kategori Lebih Lama -->
        <?php if (!empty($categories['older'])): ?>
        <div class="category-card older">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="fas fa-history me-2"></i>Sebelumnya
                    <span class="badge bg-secondary ms-2"><?php echo count($categories['older']); ?></span>
                </h4>
                <small class="text-muted">Instalasi sebelumnya</small>
            </div>
            <div class="row">
                <?php foreach ($categories['older'] as $customer): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0"><?php echo htmlspecialchars($customer['nama_lengkap']); ?></h6>
                            <span class="badge bg-secondary status-badge">Selesai</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($customer['email']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($customer['nomor_hp']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-map-marker-alt me-1"></i><?php echo htmlspecialchars($customer['alamat_instalasi']); ?>
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-ruler me-1"></i><?php echo $customer['kabel_meter']; ?> meter
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-user-tie me-1"></i><?php echo htmlspecialchars($customer['teknisi_name']); ?>
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-calendar me-1"></i><?php echo date('d M Y', strtotime($customer['tanggal_instalasi'])); ?>
                        </p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="show_chart.php" class="btn btn-outline-light">
                <i class="fas fa-chart-line me-2"></i>Lihat Grafik
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
