<?php
require_once 'config/config.php';
requireRole(['admin']);

$database = new Database();
$db = $database->getConnection();

// Filter dan pencarian
$search = isset($_GET['search']) ? sanitizeInput($_GET['search']) : '';
$status_filter = isset($_GET['status']) ? sanitizeInput($_GET['status']) : '';

// Query dengan filter
$where_conditions = [];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(nama_lengkap LIKE ? OR nomor_hp LIKE ? OR email LIKE ? OR nik_ktp LIKE ?)";
    $search_param = "%$search%";
    $params = array_merge($params, [$search_param, $search_param, $search_param, $search_param]);
}

if (!empty($status_filter)) {
    $where_conditions[] = "status = ?";
    $params[] = $status_filter;
}

$where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';

// Query data pelanggan
$query = "SELECT c.*, u.full_name as created_by_name 
          FROM customers c 
          LEFT JOIN users u ON c.created_by = u.id 
          $where_clause 
          ORDER BY c.created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Statistik
$stats_query = "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved,
    SUM(CASE WHEN status = 'installed' THEN 1 ELSE 0 END) as installed,
    SUM(CASE WHEN status = 'cancelled' THEN 1 ELSE 0 END) as cancelled
    FROM customers";
$stats_stmt = $db->prepare($stats_query);
$stats_stmt->execute();
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Pelanggan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .filter-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .data-card {
            background: white;
            border-radius: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .status-badge {
            font-size: 0.75rem;
        }
        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link active" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="installed_customers.php">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Data Pelanggan</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <!-- Statistik -->
                        <div class="row mb-4">
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-primary"><?php echo $stats['total']; ?></h5>
                                        <p class="card-text">Total Pelanggan</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-warning"><?php echo $stats['pending']; ?></h5>
                                        <p class="card-text">Pending</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-success"><?php echo $stats['installed']; ?></h5>
                                        <p class="card-text">Terinstalasi</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-danger"><?php echo $stats['cancelled']; ?></h5>
                                        <p class="card-text">Dibatalkan</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Filter -->
                        <div class="filter-card">
                            <form method="GET" class="row g-3">
                                <div class="col-md-4">
                                    <label for="search" class="form-label">Pencarian</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           placeholder="Nama, HP, Email, atau NIK..." value="<?php echo $search; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="status" class="form-label">Status</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">Semua Status</option>
                                        <option value="pending" <?php echo $status_filter == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                        <option value="approved" <?php echo $status_filter == 'approved' ? 'selected' : ''; ?>>Approved</option>
                                        <option value="installed" <?php echo $status_filter == 'installed' ? 'selected' : ''; ?>>Installed</option>
                                        <option value="cancelled" <?php echo $status_filter == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary me-2">
                                        <i class="fas fa-search me-2"></i>Cari
                                    </button>
                                    <a href="customers.php" class="btn btn-outline-secondary">
                                        <i class="fas fa-refresh me-2"></i>Reset
                                    </a>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <a href="add_customer.php" class="btn btn-success w-100">
                                        <i class="fas fa-plus me-2"></i>Tambah
                                    </a>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Tabel Data -->
                        <div class="data-card">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>No</th>
                                            <th>Nama Lengkap</th>
                                            <th>Nomor HP</th>
                                            <th>Email</th>
                                            <th>Status</th>
                                            <th>Tanggal Input</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($customers)): ?>
                                            <tr>
                                                <td colspan="7" class="text-center py-4">
                                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                                    <p class="text-muted">Tidak ada data pelanggan</p>
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <?php foreach ($customers as $index => $customer): ?>
                                                <tr>
                                                    <td><?php echo $index + 1; ?></td>
                                                    <td>
                                                        <div>
                                                            <strong><?php echo $customer['nama_lengkap']; ?></strong>
                                                            <br>
                                                            <small class="text-muted"><?php echo $customer['pekerjaan']; ?></small>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $customer['nomor_hp']; ?></td>
                                                    <td><?php echo $customer['email'] ?: '-'; ?></td>
                                                    <td>
                                                        <?php
                                                        $status_class = '';
                                                        $status_text = '';
                                                        switch ($customer['status']) {
                                                            case 'pending':
                                                                $status_class = 'warning';
                                                                $status_text = 'Pending';
                                                                break;
                                                            case 'approved':
                                                                $status_class = 'info';
                                                                $status_text = 'Approved';
                                                                break;
                                                            case 'installed':
                                                                $status_class = 'success';
                                                                $status_text = 'Installed';
                                                                break;
                                                            case 'cancelled':
                                                                $status_class = 'danger';
                                                                $status_text = 'Cancelled';
                                                                break;
                                                            case 'rejected':
                                                                $status_class = 'secondary';
                                                                $status_text = 'Rejected';
                                                                break;
                                                        }
                                                        ?>
                                                        <span class="badge bg-<?php echo $status_class; ?> status-badge">
                                                            <?php echo $status_text; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo formatDate($customer['created_at']); ?></td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="customer_detail.php?id=<?php echo $customer['id']; ?>" 
                                                               class="btn btn-sm btn-outline-primary" title="Detail">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a href="customer_edit.php?id=<?php echo $customer['id']; ?>" 
                                                               class="btn btn-sm btn-outline-warning" title="Edit Data">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <a href="customer_edit_status.php?id=<?php echo $customer['id']; ?>" 
                                                               class="btn btn-sm btn-outline-info" title="Edit Status">
                                                                <i class="fas fa-flag"></i>
                                                            </a>
                                                            <a href="delete_customer.php?id=<?php echo $customer['id']; ?>" 
                                                               class="btn btn-sm btn-outline-danger" title="Hapus"
                                                               onclick="return confirmDelete('<?php echo $customer['nama_lengkap']; ?>')">
                                                                <i class="fas fa-trash"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function confirmDelete(customerName) {
            return confirm(`⚠️ PERINGATAN!\n\nAnda akan menghapus data pelanggan:\n"${customerName}"\n\nTindakan ini TIDAK DAPAT DIBATALKAN!\n\nApakah Anda yakin ingin melanjutkan?`);
        }
    </script>
</body>
</html>
