# Engineer On Site App (ENSIA)
## PT Maintek Juara Intisolusi

Aplikasi manajemen teknisi pemasangan internet yang memungkinkan admin untuk input data pelanggan, supervisor untuk menyetujui data, dan teknisi untuk melakukan instalasi dengan tracking koordinat GPS.

### Fitur Utama

#### Dashboard Admin
- Statistik data pelanggan (baru, terinstalasi, pending, dibatalkan)
- Grafik pemasangan per bulan
- Overview lengkap sistem

#### Manajemen Pelanggan
- Input data pelanggan lengkap (nama, pekerjaan, alamat, HP, email, NIK KTP)
- Edit dan hapus data pelanggan
- Pencarian dan filter data
- Detail pelanggan dengan log aktivitas

#### Persetujuan Supervisor
- Review data pelanggan yang pending
- Approve atau reject data pelanggan
- Tracking status persetujuan

#### Instalasi Teknisi
- Daftar pelanggan yang siap diinstalasi
- Input data instalasi (panjang kabel, koordinat GPS)
- Update status instalasi
- Tracking lokasi dengan GPS

#### Laporan & Export
- Export data ke Excel dan PDF
- Filter data berdasarkan status dan tanggal
- Print data pelanggan dalam format PDF
- Laporan statistik lengkap

### Teknologi yang Digunakan

- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: Bootstrap 5, Chart.js
- **PDF Export**: mPDF
- **Maps**: Google Maps API (opsional)

### Instalasi

1. **Clone atau download aplikasi**
   ```bash
   git clone [repository-url]
   cd ensia1
   ```

2. **Install dependencies**
   ```bash
   composer install
   ```

3. **Setup Database**
   - Buat database MySQL dengan nama `ensia_db`
   - Import file `database/schema.sql` ke database
   - Update konfigurasi database di `config/database.php`

4. **Konfigurasi Web Server**
   - Pastikan web server (Apache/Nginx) sudah terinstall
   - Set document root ke folder aplikasi
   - Pastikan PHP extension PDO MySQL aktif

5. **Set Permissions**
   ```bash
   chmod 755 uploads/
   chmod 644 config/*.php
   ```

### Konfigurasi Database

Edit file `config/database.php`:

```php
private $host = 'localhost';
private $db_name = 'ensia_db';
private $username = 'your_username';
private $password = 'your_password';
```

### Default Login

Setelah instalasi, gunakan akun default berikut:

- **Admin**: `admin@ensia.com` / `password`
- **Supervisor**: `supervisor@ensia.com` / `password`
- **Teknisi**: `teknisi1@ensia.com` / `password`

**PENTING**: Ganti password default setelah login pertama!

### Struktur Database

#### Tabel `users`
- Menyimpan data admin, supervisor, dan teknisi
- Role-based access control

#### Tabel `customers`
- Data pelanggan lengkap
- Status tracking (pending, approved, installed, cancelled, rejected)

#### Tabel `installations`
- Data instalasi oleh teknisi
- Koordinat GPS dan panjang kabel
- Status instalasi

#### Tabel `activity_logs`
- Log semua aktivitas sistem
- Audit trail lengkap

### Penggunaan

#### Admin
1. Login dengan akun admin
2. Input data pelanggan baru
3. Monitor dashboard untuk statistik
4. Generate laporan dan export data

#### Supervisor
1. Login dengan akun supervisor
2. Review data pelanggan pending
3. Approve atau reject data pelanggan
4. Monitor progress instalasi

#### Teknisi
1. Login dengan akun teknisi
2. Lihat daftar pelanggan yang siap diinstalasi
3. Mulai instalasi dan input data (kabel, koordinat)
4. Update status instalasi

### API Endpoints

- `GET /login.php` - Halaman login
- `GET /dashboard.php` - Dashboard sesuai role
- `GET /customers.php` - Data pelanggan (admin)
- `GET /add_customer.php` - Tambah pelanggan (admin)
- `GET /approvals.php` - Persetujuan (supervisor)
- `GET /installations.php` - Instalasi (teknisi)
- `GET /reports.php` - Laporan (admin)
- `GET /customer_detail.php?id=X` - Detail pelanggan
- `GET /customer_print.php?id=X` - Print PDF pelanggan

### Troubleshooting

#### Error Koneksi Database
- Pastikan MySQL service berjalan
- Cek konfigurasi database di `config/database.php`
- Pastikan database `ensia_db` sudah dibuat

#### Error Export PDF
- Pastikan mPDF sudah terinstall: `composer install`
- Cek permission folder `vendor/`

#### Error Session
- Pastikan PHP session extension aktif
- Cek konfigurasi session di `php.ini`

### Security Notes

- Ganti password default setelah instalasi
- Gunakan HTTPS untuk production
- Regular backup database
- Update dependencies secara berkala

### Support

Untuk bantuan teknis, hubungi:
- **Developer**: Amiruloh
- **Institution**: AMIK CBI Sukabumi
- **Purpose**: Tugas Akhir D3 Manajemen Informatika

### License

Aplikasi ini dibuat untuk keperluan akademik dan internal PT Maintek Juara Intisolusi.

---

**Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi**
