<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Fitur Delete Data Pelanggan - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .demo-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .customer-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
        }
        .customer-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .btn-delete {
            background: #dc3545;
            border-color: #dc3545;
            color: white;
        }
        .btn-delete:hover {
            background: #c82333;
            border-color: #bd2130;
            color: white;
        }
        .warning-icon {
            font-size: 3rem;
            color: #dc3545;
            margin-bottom: 1rem;
        }
        .modal-delete {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>🗑️ Demo - Fitur Delete Data Pelanggan</h3>
            <p class="lead">Fitur hapus data pelanggan dengan konfirmasi dan validasi</p>
        </div>
        
        <!-- Features Info -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-shield-alt me-2"></i>Validasi Delete</h6>
                    <p class="text-muted small mb-0">Tidak bisa hapus pelanggan yang sudah ada instalasi</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-exclamation-triangle me-2"></i>Konfirmasi</h6>
                    <p class="text-muted small mb-0">Konfirmasi ganda sebelum menghapus data</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <h6><i class="fas fa-trash me-2"></i>Hapus File</h6>
                    <p class="text-muted small mb-0">Otomatis hapus foto KTP yang terkait</p>
                </div>
            </div>
        </div>
        
        <!-- Demo Data Pelanggan -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-users me-2"></i>Data Pelanggan Sample
            </h4>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0">Ahmad Wijaya</h6>
                            <span class="badge bg-warning">Pending</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i>081234567890
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i>ahmad.wijaya@email.com
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-id-card me-1"></i>1234567890123456
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-calendar me-1"></i>07 Sep 2025
                        </p>
                        <div class="mt-3">
                            <button class="btn btn-sm btn-outline-primary me-2" title="Detail">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-warning me-2" title="Edit">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger" title="Hapus" 
                                    onclick="showDeleteModal('Ahmad Wijaya', 'pending', false)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="customer-card">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0">Budi Santoso</h6>
                            <span class="badge bg-success">Installed</span>
                        </div>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-phone me-1"></i>081234567892
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-envelope me-1"></i>budi.santoso@email.com
                        </p>
                        <p class="text-muted small mb-1">
                            <i class="fas fa-id-card me-1"></i>1234567890123458
                        </p>
                        <p class="text-muted small mb-0">
                            <i class="fas fa-calendar me-1"></i>15 Jan 2024
                        </p>
                        <div class="mt-3">
                            <button class="btn btn-sm btn-outline-primary me-2" title="Detail">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-warning me-2" title="Edit">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger" title="Hapus" 
                                    onclick="showDeleteModal('Budi Santoso', 'installed', true)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content modal-delete">
                    <div class="modal-header border-0">
                        <h5 class="modal-title">
                            <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                            Konfirmasi Hapus
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <i class="fas fa-exclamation-triangle warning-icon"></i>
                        <h6 id="deleteCustomerName"></h6>
                        <p class="text-muted">Apakah Anda yakin ingin menghapus data pelanggan ini?</p>
                        
                        <div id="deleteWarning" class="alert alert-warning" style="display: none;">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Peringatan:</strong> Pelanggan ini sudah memiliki data instalasi dan tidak dapat dihapus!
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Informasi:</strong> Tindakan ini akan menghapus:
                            <ul class="list-unstyled mt-2 mb-0">
                                <li><i class="fas fa-check me-2"></i>Data pelanggan</li>
                                <li><i class="fas fa-check me-2"></i>Foto KTP (jika ada)</li>
                                <li><i class="fas fa-check me-2"></i>Log aktivitas</li>
                            </ul>
                        </div>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-2"></i>Batal
                        </button>
                        <button type="button" class="btn btn-delete" id="confirmDeleteBtn" onclick="confirmDelete()">
                            <i class="fas fa-trash me-2"></i>Ya, Hapus
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Success Modal -->
        <div class="modal fade" id="successModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content modal-delete">
                    <div class="modal-body text-center">
                        <i class="fas fa-check-circle text-success" style="font-size: 4rem; margin-bottom: 1rem;"></i>
                        <h5 class="text-success">Berhasil!</h5>
                        <p class="text-muted">Data pelanggan berhasil dihapus.</p>
                        <button type="button" class="btn btn-success" data-bs-dismiss="modal">
                            <i class="fas fa-check me-2"></i>OK
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Features Detail -->
        <div class="row">
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-shield-alt me-2 text-success"></i>Keamanan Delete</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Validasi relasi data</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Konfirmasi ganda</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Hapus file terkait</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Log aktivitas</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Rollback jika gagal</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-cogs me-2 text-info"></i>Fitur Delete</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Tombol delete di tabel</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Modal konfirmasi</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Validasi status</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Feedback visual</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Hapus otomatis file</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_add_customer.php" class="btn btn-outline-light">
                <i class="fas fa-user-plus me-2"></i>Demo Tambah Pelanggan
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentCustomer = null;
        let hasInstallation = false;
        
        function showDeleteModal(customerName, status, hasInstall) {
            currentCustomer = customerName;
            hasInstallation = hasInstall;
            
            document.getElementById('deleteCustomerName').textContent = customerName;
            
            const warningDiv = document.getElementById('deleteWarning');
            const confirmBtn = document.getElementById('confirmDeleteBtn');
            
            if (hasInstall) {
                warningDiv.style.display = 'block';
                confirmBtn.disabled = true;
                confirmBtn.innerHTML = '<i class="fas fa-ban me-2"></i>Tidak Dapat Dihapus';
            } else {
                warningDiv.style.display = 'none';
                confirmBtn.disabled = false;
                confirmBtn.innerHTML = '<i class="fas fa-trash me-2"></i>Ya, Hapus';
            }
            
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        }
        
        function confirmDelete() {
            if (!hasInstallation) {
                // Simulate delete process
                bootstrap.Modal.getInstance(document.getElementById('deleteModal')).hide();
                
                setTimeout(() => {
                    new bootstrap.Modal(document.getElementById('successModal')).show();
                }, 500);
            }
        }
    </script>
</body>
</html>
