-- Database Schema untuk Aplikasi ENSIA
-- Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

CREATE DATABASE IF NOT EXISTS ensia_db;
USE ensia_db;

-- Tabel users untuk admin, supervisor, dan teknisi
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    role ENUM('admin', 'supervisor', 'teknisi') NOT NULL,
    email VARCHAR(100),
    phone VARCHAR(20),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabel pelanggan
CREATE TABLE customers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_lengkap VARCHAR(100) NOT NULL,
    pekerjaan VARCHAR(100),
    alamat_lengkap TEXT NOT NULL,
    nomor_hp VARCHAR(20) NOT NULL,
    email VARCHAR(100),
    nik_ktp VARCHAR(16) UNIQUE NOT NULL,
    status ENUM('pending', 'approved', 'rejected', 'installed', 'cancelled') DEFAULT 'pending',
    created_by INT,
    approved_by INT,
    approved_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES users(id),
    FOREIGN KEY (approved_by) REFERENCES users(id)
);

-- Tabel instalasi
CREATE TABLE installations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    customer_id INT NOT NULL,
    teknisi_id INT NOT NULL,
    kabel_meter INT NOT NULL,
    latitude DECIMAL(10, 8),
    longitude DECIMAL(11, 8),
    alamat_instalasi TEXT,
    catatan TEXT,
    status ENUM('assigned', 'in_progress', 'completed', 'failed') DEFAULT 'assigned',
    tanggal_instalasi DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (customer_id) REFERENCES customers(id),
    FOREIGN KEY (teknisi_id) REFERENCES users(id)
);

-- Tabel log aktivitas
CREATE TABLE activity_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    action VARCHAR(100) NOT NULL,
    description TEXT,
    table_name VARCHAR(50),
    record_id INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

-- Insert data default admin
INSERT INTO users (username, password, full_name, role, email) VALUES 
('admin@ensia.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrator', 'admin', 'admin@ensia.com'),
('supervisor@ensia.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Supervisor', 'supervisor', 'supervisor@ensia.com'),
('teknisi1@ensia.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Teknisi 1', 'teknisi', 'teknisi1@ensia.com'),
('teknisi2@ensia.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Teknisi 2', 'teknisi', 'teknisi2@ensia.com'),
('manager@ensia.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Manager', 'admin', 'manager@ensia.com');

-- Password default: password

-- Insert sample customers for testing
INSERT INTO customers (nama_lengkap, pekerjaan, alamat_lengkap, nomor_hp, email, nik_ktp, status, created_by) VALUES 
('Ahmad Wijaya', 'Karyawan Swasta', 'Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567890', 'ahmad.wijaya@email.com', '1234567890123456', 'pending', 1),
('Siti Nurhaliza', 'Guru', 'Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567891', 'siti.nurhaliza@email.com', '1234567890123457', 'approved', 1),
('Budi Santoso', 'Wiraswasta', 'Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567892', 'budi.santoso@email.com', '1234567890123458', 'installed', 1),
('Dewi Sartika', 'PNS', 'Jl. Gatot Subroto No. 321, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567893', 'dewi.sartika@email.com', '1234567890123459', 'cancelled', 1),
('Rudi Hartono', 'Dokter', 'Jl. HR Rasuna Said No. 654, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567894', 'rudi.hartono@email.com', '1234567890123460', 'pending', 1),
('Eko Prasetyo', 'Pedagang', 'Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567895', 'eko.prasetyo@email.com', '1234567890123461', 'approved', 1),
('Maya Sari', 'Perawat', 'Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567896', 'maya.sari@email.com', '1234567890123462', 'installed', 1),
('Agus Supriyadi', 'Sopir', 'Jl. Ahmad Yani No. 78, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567897', 'agus.supriyadi@email.com', '1234567890123463', 'pending', 1),
('Rina Wulandari', 'Ibu Rumah Tangga', 'Jl. Pahlawan No. 90, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', '081234567898', 'rina.wulandari@email.com', '1234567890123464', 'cancelled', 1);

-- Insert sample installations for testing
INSERT INTO installations (customer_id, teknisi_id, kabel_meter, latitude, longitude, alamat_instalasi, catatan, status, tanggal_instalasi) VALUES 
(3, 3, 50, -6.9194, 106.9270, 'Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', 'Instalasi berhasil, sinyal kuat', 'completed', '2024-01-15'),
(2, 3, 75, -6.9194, 106.9270, 'Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', 'Instalasi pending, menunggu konfirmasi pelanggan', 'in_progress', NULL),
(7, 4, 60, -6.9194, 106.9270, 'Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', 'Instalasi selesai, pelanggan puas', 'completed', '2024-01-20'),
(6, 4, 40, -6.9194, 106.9270, 'Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi', 'Instalasi baru dimulai', 'assigned', NULL);

-- Insert sample activity logs for testing
INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES 
(1, 'create', 'Menambah data pelanggan baru', 'customers', 1),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 2),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 3),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 4),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 5),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 6),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 7),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 8),
(1, 'create', 'Menambah data pelanggan baru', 'customers', 9),
(2, 'approve', 'Menyetujui data pelanggan', 'customers', 2),
(2, 'approve', 'Menyetujui data pelanggan', 'customers', 6),
(3, 'create', 'Memulai instalasi pelanggan', 'installations', 1),
(3, 'update', 'Update data instalasi', 'installations', 1),
(3, 'create', 'Memulai instalasi pelanggan', 'installations', 2),
(4, 'create', 'Memulai instalasi pelanggan', 'installations', 3),
(4, 'update', 'Update data instalasi', 'installations', 3),
(4, 'create', 'Memulai instalasi pelanggan', 'installations', 4);
