<?php
require_once 'config/config.php';
requireRole(['admin', 'supervisor', 'teknisi']);

$database = new Database();
$db = $database->getConnection();

$customer_id = (int)($_GET['id'] ?? 0);

if (!$customer_id) {
    header('Location: dashboard.php');
    exit();
}

// Query data pelanggan lengkap
$query = "SELECT c.*, u.full_name as created_by_name, 
          i.kabel_meter, i.latitude, i.longitude, i.alamat_instalasi, i.catatan, i.tanggal_instalasi, i.status as installation_status,
          u2.full_name as teknisi_name
          FROM customers c 
          LEFT JOIN users u ON c.created_by = u.id 
          LEFT JOIN installations i ON c.id = i.customer_id
          LEFT JOIN users u2 ON i.teknisi_id = u2.id
          WHERE c.id = ?";
$stmt = $db->prepare($query);
$stmt->execute([$customer_id]);
$customer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$customer) {
    header('Location: dashboard.php');
    exit();
}

// Generate PDF
require_once 'vendor/autoload.php';

$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'orientation' => 'P',
    'margin_left' => 15,
    'margin_right' => 15,
    'margin_top' => 16,
    'margin_bottom' => 16,
    'margin_header' => 9,
    'margin_footer' => 9,
]);

$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Data Pelanggan - ' . $customer['nama_lengkap'] . '</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 10px;
        }
        .company {
            font-size: 14px;
            color: #666;
        }
        .title {
            font-size: 18px;
            font-weight: bold;
            margin: 20px 0;
            text-align: center;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table td {
            padding: 8px;
            border: 1px solid #ddd;
            vertical-align: top;
        }
        .info-table .label {
            background-color: #f5f5f5;
            font-weight: bold;
            width: 30%;
        }
        .status {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .status-pending { background-color: #fff3cd; color: #856404; }
        .status-approved { background-color: #d1ecf1; color: #0c5460; }
        .status-installed { background-color: #d4edda; color: #155724; }
        .status-cancelled { background-color: #f8d7da; color: #721c24; }
        .status-rejected { background-color: #e2e3e5; color: #383d41; }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding: 10px;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            color: #333;
        }
        .map-link {
            color: #667eea;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo">MAJUIN</div>
        <div class="company">' . APP_NAME . '</div>
        <div class="company">' . APP_COMPANY . '</div>
    </div>
    
    <div class="title">DATA PELANGGAN</div>
    
    <table class="info-table">
        <tr>
            <td class="label">Nama Lengkap</td>
            <td>' . $customer['nama_lengkap'] . '</td>
        </tr>
        <tr>
            <td class="label">Pekerjaan</td>
            <td>' . ($customer['pekerjaan'] ?: '-') . '</td>
        </tr>
        <tr>
            <td class="label">Nomor HP</td>
            <td>' . $customer['nomor_hp'] . '</td>
        </tr>
        <tr>
            <td class="label">Email</td>
            <td>' . ($customer['email'] ?: '-') . '</td>
        </tr>
        <tr>
            <td class="label">NIK KTP</td>
            <td>' . $customer['nik_ktp'] . '</td>
        </tr>
        <tr>
            <td class="label">Status</td>
            <td>
                <span class="status status-' . $customer['status'] . '">' . ucfirst($customer['status']) . '</span>
            </td>
        </tr>
        <tr>
            <td class="label">Alamat Lengkap</td>
            <td>' . nl2br($customer['alamat_lengkap']) . '</td>
        </tr>
        <tr>
            <td class="label">Dibuat Oleh</td>
            <td>' . $customer['created_by_name'] . '</td>
        </tr>
        <tr>
            <td class="label">Tanggal Input</td>
            <td>' . formatDateTime($customer['created_at']) . '</td>
        </tr>';

if ($customer['approved_at']) {
    $html .= '
        <tr>
            <td class="label">Tanggal Disetujui</td>
            <td>' . formatDateTime($customer['approved_at']) . '</td>
        </tr>';
}

$html .= '
    </table>';

// Data Instalasi
if ($customer['kabel_meter'] || $customer['latitude'] || $customer['longitude']) {
    $html .= '
    <div class="section-title">DATA INSTALASI</div>
    <table class="info-table">
        <tr>
            <td class="label">Status Instalasi</td>
            <td>
                <span class="status status-' . $customer['installation_status'] . '">' . ucfirst($customer['installation_status']) . '</span>
            </td>
        </tr>
        <tr>
            <td class="label">Panjang Kabel</td>
            <td>' . ($customer['kabel_meter'] ? $customer['kabel_meter'] . ' meter' : '-') . '</td>
        </tr>
        <tr>
            <td class="label">Teknisi</td>
            <td>' . ($customer['teknisi_name'] ?: '-') . '</td>
        </tr>
        <tr>
            <td class="label">Tanggal Instalasi</td>
            <td>' . ($customer['tanggal_instalasi'] ? formatDate($customer['tanggal_instalasi']) : '-') . '</td>
        </tr>';

    if ($customer['latitude'] && $customer['longitude']) {
        $html .= '
        <tr>
            <td class="label">Koordinat</td>
            <td>' . $customer['latitude'] . ', ' . $customer['longitude'] . '</td>
        </tr>';
    }

    if ($customer['alamat_instalasi']) {
        $html .= '
        <tr>
            <td class="label">Alamat Instalasi</td>
            <td>' . nl2br($customer['alamat_instalasi']) . '</td>
        </tr>';
    }

    if ($customer['catatan']) {
        $html .= '
        <tr>
            <td class="label">Catatan Instalasi</td>
            <td>' . nl2br($customer['catatan']) . '</td>
        </tr>';
    }

    $html .= '
    </table>';
}

$html .= '
    <div class="footer">
        <p>Dicetak pada: ' . date('d/m/Y H:i') . ' | ' . APP_NAME . ' - ' . APP_COMPANY . '</p>
        <p>Developed by ' . APP_DEVELOPER . ' untuk ' . APP_PURPOSE . '</p>
    </div>
</body>
</html>';

$mpdf->WriteHTML($html);
$mpdf->Output('data_pelanggan_' . $customer['nama_lengkap'] . '_' . date('Y-m-d') . '.pdf', 'D');
?>
