<?php
require_once 'config/config.php';
requireRole(['admin']);

$database = new Database();
$db = $database->getConnection();

$success = '';
$error = '';

// Handle AJAX form submission
if ($_POST && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    
    $action = $_POST['action'];
    $response = ['success' => false, 'message' => ''];
    
    if ($action == 'add_technician') {
        $nama_teknisi = sanitizeInput($_POST['nama_teknisi']);
        $nomor_hp = sanitizeInput($_POST['nomor_hp']);
        $email = sanitizeInput($_POST['email']);
        $username = sanitizeInput($_POST['username']);
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        
        try {
            // Check if username or email already exists
            $check_query = "SELECT id FROM users WHERE username = ? OR email = ?";
            $check_stmt = $db->prepare($check_query);
            $check_stmt->execute([$username, $email]);
            
            if ($check_stmt->rowCount() > 0) {
                $response['message'] = 'Username atau email sudah digunakan!';
            } else {
                // Insert new technician
                $query = "INSERT INTO users (username, email, password, full_name, role, nomor_hp, created_by) VALUES (?, ?, ?, ?, 'teknisi', ?, ?)";
                $stmt = $db->prepare($query);
                
                if ($stmt->execute([$username, $email, $password, $nama_teknisi, $nomor_hp, $_SESSION['user_id']])) {
                    $response['success'] = true;
                    $response['message'] = 'Teknisi berhasil ditambahkan!';
                    
                    // Log activity
                    $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'create', 'Menambahkan teknisi baru: $nama_teknisi', 'users', ?)";
                    $log_stmt = $db->prepare($log_query);
                    $log_stmt->execute([$_SESSION['user_id'], $db->lastInsertId()]);
                } else {
                    $response['message'] = 'Gagal menambahkan teknisi!';
                }
            }
        } catch (Exception $e) {
            $response['message'] = 'Error: ' . $e->getMessage();
        }
    } elseif ($action == 'assign_technician') {
        $customer_id = (int)$_POST['customer_id'];
        $teknisi_id = (int)$_POST['teknisi_id'];
        
        try {
            // Check if customer already has installation
            $check_query = "SELECT id FROM installations WHERE customer_id = ?";
            $check_stmt = $db->prepare($check_query);
            $check_stmt->execute([$customer_id]);
            
            if ($check_stmt->rowCount() > 0) {
                $response['message'] = 'Pelanggan ini sudah memiliki instalasi!';
            } else {
                // Create installation assignment
                $query = "INSERT INTO installations (customer_id, teknisi_id, kabel_meter, status) VALUES (?, ?, 0, 'assigned')";
                $stmt = $db->prepare($query);
                
                if ($stmt->execute([$customer_id, $teknisi_id])) {
                    $response['success'] = true;
                    $response['message'] = 'Teknisi berhasil ditugaskan!';
                    
                    // Log activity
                    $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'create', 'Menugaskan teknisi ke pelanggan', 'installations', ?)";
                    $log_stmt = $db->prepare($log_query);
                    $log_stmt->execute([$_SESSION['user_id'], $db->lastInsertId()]);
                } else {
                    $response['message'] = 'Gagal menugaskan teknisi!';
                }
            }
        } catch (Exception $e) {
            $response['message'] = 'Error: ' . $e->getMessage();
        }
    }
    
    echo json_encode($response);
    exit;
}

// Get all technicians
$tech_query = "SELECT * FROM users WHERE role = 'teknisi' ORDER BY created_at DESC";
$tech_stmt = $db->prepare($tech_query);
$tech_stmt->execute();
$technicians = $tech_stmt->fetchAll(PDO::FETCH_ASSOC);

// Get approved customers without installation
$customers_query = "SELECT c.* FROM customers c 
                    LEFT JOIN installations i ON c.id = i.customer_id 
                    WHERE c.status = 'approved' AND i.id IS NULL
                    ORDER BY c.created_at DESC";
$customers_stmt = $db->prepare($customers_query);
$customers_stmt->execute();
$customers = $customers_stmt->fetchAll(PDO::FETCH_ASSOC);

// Get installation assignments
$assignments_query = "SELECT i.*, c.nama_lengkap as customer_name, u.full_name as teknisi_name 
                      FROM installations i
                      JOIN customers c ON i.customer_id = c.id
                      JOIN users u ON i.teknisi_id = u.id
                      ORDER BY i.created_at DESC";
$assignments_stmt = $db->prepare($assignments_query);
$assignments_stmt->execute();
$assignments = $assignments_stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Teknisi - Admin - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="responsive_design.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .main-content {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin: 2rem 0;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 1.5rem;
        }
        .card-header {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            border-radius: 10px 10px 0 0;
            padding: 1rem 1.5rem;
        }
        .btn-primary {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(45deg, #5a6fd8, #6a4190);
        }
        .table th {
            background: #f8f9fa;
            border-top: none;
        }
        .badge-status {
            font-size: 0.75rem;
            padding: 0.5rem 0.75rem;
        }
        .technician-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #667eea;
        }
        .customer-card {
            background: #e3f2fd;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #2196f3;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar">
                <div class="sidebar-content">
                    <div class="logo-section">
                        <img src="https://via.placeholder.com/150x50/667eea/ffffff?text=Majuin" alt="Majuin Logo" class="logo">
                    </div>
                    <nav class="nav flex-column">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="approvals.php">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <a class="nav-link active" href="admin_manage_technicians.php">
                            <i class="fas fa-users-cog me-2"></i>Kelola Teknisi
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 main-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-users-cog me-2"></i>Kelola Teknisi</h2>
                    <span class="badge bg-primary fs-6">Admin</span>
                </div>
                
                <!-- Alert akan muncul via JavaScript -->
                <div id="alertArea"></div>
                
                <!-- Add Technician Form -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user-plus me-2"></i>Tambah Teknisi Baru</h5>
                    </div>
                    <div class="card-body">
                        <form id="addTechnicianForm" method="POST">
                            <input type="hidden" name="ajax" value="1">
                            <input type="hidden" name="action" value="add_technician">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nama_teknisi" class="form-label">Nama Teknisi <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="nama_teknisi" name="nama_teknisi" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="nomor_hp" class="form-label">Nomor HP <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" id="nomor_hp" name="nomor_hp" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="username" name="username" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" id="password" name="password" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary w-100" id="addTechnicianBtn">
                                        <i class="fas fa-plus me-2"></i>Tambah Teknisi
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Assign Technician Form -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-tasks me-2"></i>Tugaskan Teknisi</h5>
                    </div>
                    <div class="card-body">
                        <form id="assignTechnicianForm" method="POST">
                            <input type="hidden" name="ajax" value="1">
                            <input type="hidden" name="action" value="assign_technician">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="customer_id" class="form-label">Pilih Pelanggan <span class="text-danger">*</span></label>
                                    <select class="form-select" id="customer_id" name="customer_id" required>
                                        <option value="">-- Pilih Pelanggan --</option>
                                        <?php foreach ($customers as $customer): ?>
                                            <option value="<?php echo $customer['id']; ?>">
                                                <?php echo htmlspecialchars($customer['nama_lengkap']); ?> - <?php echo htmlspecialchars($customer['nomor_hp']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="teknisi_id" class="form-label">Pilih Teknisi <span class="text-danger">*</span></label>
                                    <select class="form-select" id="teknisi_id" name="teknisi_id" required>
                                        <option value="">-- Pilih Teknisi --</option>
                                        <?php foreach ($technicians as $tech): ?>
                                            <option value="<?php echo $tech['id']; ?>">
                                                <?php echo htmlspecialchars($tech['full_name']); ?> - <?php echo htmlspecialchars($tech['nomor_hp']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary" id="assignTechnicianBtn">
                                    <i class="fas fa-user-check me-2"></i>Tugaskan Teknisi
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Technicians List -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-list me-2"></i>Daftar Teknisi</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($technicians)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada teknisi yang terdaftar</p>
                            </div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($technicians as $tech): ?>
                                    <div class="col-md-6 col-lg-4 mb-3">
                                        <div class="technician-card">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <h6 class="mb-0"><?php echo htmlspecialchars($tech['full_name']); ?></h6>
                                                <span class="badge bg-success badge-status">Aktif</span>
                                            </div>
                                            <p class="text-muted small mb-1">
                                                <i class="fas fa-phone me-1"></i><?php echo htmlspecialchars($tech['nomor_hp']); ?>
                                            </p>
                                            <p class="text-muted small mb-1">
                                                <i class="fas fa-envelope me-1"></i><?php echo htmlspecialchars($tech['email']); ?>
                                            </p>
                                            <p class="text-muted small mb-2">
                                                <i class="fas fa-user me-1"></i><?php echo htmlspecialchars($tech['username']); ?>
                                            </p>
                                            <small class="text-muted">
                                                <i class="fas fa-calendar me-1"></i>
                                                Dibuat: <?php echo date('d M Y', strtotime($tech['created_at'])); ?>
                                            </small>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Assignment List -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-tasks me-2"></i>Penugasan Teknisi</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($assignments)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-tasks fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada penugasan teknisi</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Pelanggan</th>
                                            <th>Teknisi</th>
                                            <th>Status</th>
                                            <th>Tanggal Tugas</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($assignments as $assignment): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($assignment['customer_name']); ?></td>
                                                <td><?php echo htmlspecialchars($assignment['teknisi_name']); ?></td>
                                                <td>
                                                    <span class="badge bg-<?php 
                                                        echo $assignment['status'] == 'assigned' ? 'warning' : 
                                                            ($assignment['status'] == 'in_progress' ? 'info' : 
                                                            ($assignment['status'] == 'completed' ? 'success' : 'danger')); 
                                                    ?> badge-status">
                                                        <?php echo ucfirst(str_replace('_', ' ', $assignment['status'])); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo date('d M Y H:i', strtotime($assignment['created_at'])); ?></td>
                                                <td>
                                                    <a href="installations.php" class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-eye me-1"></i>Lihat
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Add Technician Form AJAX
        document.getElementById('addTechnicianForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('addTechnicianBtn');
            const originalText = submitBtn.innerHTML;
            
            // Show loading
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Menambahkan...';
            submitBtn.disabled = true;
            
            // Create FormData
            const formData = new FormData(this);
            
            // Send AJAX request
            fetch('admin_manage_technicians.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert(data.message, 'success');
                    // Reset form
                    document.getElementById('addTechnicianForm').reset();
                    // Reload page to show new technician
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert(data.message, 'danger');
                }
            })
            .catch(error => {
                showAlert('Terjadi kesalahan: ' + error.message, 'danger');
            })
            .finally(() => {
                // Reset button
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        });
        
        // Assign Technician Form AJAX
        document.getElementById('assignTechnicianForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('assignTechnicianBtn');
            const originalText = submitBtn.innerHTML;
            
            // Show loading
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Menugaskan...';
            submitBtn.disabled = true;
            
            // Create FormData
            const formData = new FormData(this);
            
            // Send AJAX request
            fetch('admin_manage_technicians.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert(data.message, 'success');
                    // Reset form
                    document.getElementById('assignTechnicianForm').reset();
                    // Reload page to show new assignment
                    setTimeout(() => {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert(data.message, 'danger');
                }
            })
            .catch(error => {
                showAlert('Terjadi kesalahan: ' + error.message, 'danger');
            })
            .finally(() => {
                // Reset button
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        });
        
        // Show alert function
        function showAlert(message, type) {
            // Remove existing alerts
            const existingAlerts = document.querySelectorAll('.alert');
            existingAlerts.forEach(alert => alert.remove());
            
            // Create new alert
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            // Insert alert in alert area
            document.getElementById('alertArea').appendChild(alertDiv);
            
            // Auto dismiss after 5 seconds
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 5000);
        }
    </script>
</body>
</html>
