# 🚀 ENSIA - Aplikasi Berhasil Dijalankan!

## Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

### ✅ **Status: RUNNING**

Aplikasi ENSIA telah berhasil dijalankan dengan PHP Development Server.

---

## 🌐 **Akses Aplikasi**

### **URL Utama:**
- **Main Application**: `http://localhost:8080`
- **Status App**: `http://localhost:8080/status.php`
- **Setup Database**: `http://localhost:8080/setup_database.php`
- **Test Database**: `http://localhost:8080/test_db.php`
- **Info Login**: `http://localhost:8080/login_info.html`

---

## 🔐 **Login dengan Email Fake**

### **Admin (Full Access)**
- **Email**: `admin@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Data Pelanggan, Laporan, Export

### **Manager (Full Access)**
- **Email**: `manager@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Data Pelanggan, Laporan, Export

### **Supervisor (Approval Access)**
- **Email**: `supervisor@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Persetujuan Pelanggan

### **Teknisi 1 (Installation Access)**
- **Email**: `teknisi1@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Instalasi, GPS Tracking

### **Teknisi 2 (Installation Access)**
- **Email**: `teknisi2@ensia.com`
- **Password**: `password`
- **Akses**: Dashboard, Instalasi, GPS Tracking

---

## 📊 **Data Sample Sukabumi**

### **Pelanggan (9 records)**
- Ahmad Wijaya - Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Siti Nurhaliza - Jl. Sudirman No. 456, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Budi Santoso - Jl. Thamrin No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Dewi Sartika - Jl. Gatot Subroto No. 321, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Rudi Hartono - Jl. HR Rasuna Said No. 654, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Eko Prasetyo - Jl. Siliwangi No. 12, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Maya Sari - Jl. Diponegoro No. 45, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Agus Supriyadi - Jl. Ahmad Yani No. 78, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi
- Rina Wulandari - Jl. Pahlawan No. 90, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi

### **Instalasi (4 records)**
- Budi Santoso - 50 meter kabel, Status: Completed
- Siti Nurhaliza - 75 meter kabel, Status: In Progress
- Maya Sari - 60 meter kabel, Status: Completed
- Eko Prasetyo - 40 meter kabel, Status: Assigned

---

## ✨ **Fitur Aplikasi**

### **Dashboard Admin**
- ✅ Statistik pelanggan (pending, approved, installed, cancelled)
- ✅ Grafik pemasangan per bulan
- ✅ Overview lengkap sistem

### **Manajemen Pelanggan**
- ✅ Input data pelanggan lengkap
- ✅ Edit dan hapus data pelanggan
- ✅ Pencarian dan filter data
- ✅ Detail pelanggan dengan log aktivitas

### **Persetujuan Supervisor**
- ✅ Review data pelanggan pending
- ✅ Approve atau reject data pelanggan
- ✅ Tracking status persetujuan

### **Instalasi Teknisi**
- ✅ Daftar pelanggan siap diinstalasi
- ✅ Input data instalasi (kabel, GPS)
- ✅ Update status instalasi
- ✅ Tracking lokasi dengan GPS

### **Laporan & Export**
- ✅ Export data ke Excel dan PDF
- ✅ Filter data berdasarkan status dan tanggal
- ✅ Print data pelanggan dalam format PDF
- ✅ Laporan statistik lengkap

---

## 🗄️ **Database MySQL**

### **Konfigurasi**
- **Host**: localhost
- **Database**: ensia_db
- **Username**: root
- **Password**: (kosong default)

### **Tabel**
- **users** (5 records) - Admin, supervisor, teknisi
- **customers** (9 records) - Data pelanggan Sukabumi
- **installations** (4 records) - Data instalasi dengan GPS
- **activity_logs** (16 records) - Log aktivitas sistem

---

## 🚀 **Cara Menggunakan**

### **1. Setup Database (Jika Belum)**
1. Buka: `http://localhost:8080/setup_database.php`
2. Klik "Setup Database" untuk membuat database otomatis
3. Tunggu hingga proses selesai

### **2. Test Database**
1. Buka: `http://localhost:8080/test_db.php`
2. Pastikan koneksi database berhasil
3. Lihat data sample yang sudah terimport

### **3. Login ke Aplikasi**
1. Buka: `http://localhost:8080`
2. Gunakan email dan password yang tersedia
3. Mulai menggunakan aplikasi

---

## 📱 **Screenshots Fitur**

### **Dashboard**
- Statistik cards dengan data real-time
- Grafik pemasangan per bulan
- Overview sistem lengkap

### **Data Pelanggan**
- Tabel data dengan pagination
- Filter dan pencarian
- CRUD operations lengkap

### **Persetujuan Supervisor**
- Daftar pelanggan pending
- Modal approve/reject
- Tracking status

### **Instalasi Teknisi**
- Daftar tugas instalasi
- Input data GPS dan kabel
- Update status real-time

### **Laporan & Export**
- Export Excel dan PDF
- Filter data lengkap
- Print data pelanggan

---

## 🔧 **Troubleshooting**

### **Error Database**
- Pastikan MySQL service berjalan
- Cek konfigurasi di `config/database.php`
- Jalankan setup database otomatis

### **Error Login**
- Pastikan menggunakan email yang benar
- Password default: `password`
- Cek data di database

### **Error Export**
- Pastikan mPDF sudah terinstall
- Cek permission folder
- Jalankan `composer install`

---

## 📞 **Support**

**Developer**: Amiruloh  
**Institution**: AMIK CBI Sukabumi  
**Purpose**: Tugas Akhir D3 Manajemen Informatika  

---

## 🎯 **Status: SIAP DIGUNAKAN!**

Aplikasi ENSIA telah selesai dibuat dan siap digunakan untuk keperluan Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi.

**Selamat menggunakan aplikasi ENSIA!** 🎉
