<?php
// Test Koneksi Database ENSIA
// Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

require_once 'config/database.php';

echo "<!DOCTYPE html>";
echo "<html lang='id'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Test Database - ENSIA</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<style>";
echo "body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }";
echo ".test-card { background: white; border-radius: 15px; box-shadow: 0 15px 35px rgba(0,0,0,0.1); padding: 2rem; }";
echo ".status-success { color: #28a745; }";
echo ".status-error { color: #dc3545; }";
echo "</style>";
echo "</head>";
echo "<body>";

echo "<div class='container'>";
echo "<div class='row justify-content-center'>";
echo "<div class='col-md-8'>";
echo "<div class='test-card'>";

echo "<h3 class='text-center mb-4'>🔍 Test Koneksi Database ENSIA</h3>";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if ($db) {
        echo "<div class='alert alert-success'>";
        echo "<h5><i class='fas fa-check-circle me-2'></i>✅ Koneksi Database Berhasil!</h5>";
        echo "<p>Database MySQL terhubung dengan baik.</p>";
        echo "</div>";
        
        // Test query users
        $query = "SELECT COUNT(*) as total FROM users";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>👥 Total Users:</strong> " . $result['total'] . "</p>";
        
        // Test query customers
        $query = "SELECT COUNT(*) as total FROM customers";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>👤 Total Customers:</strong> " . $result['total'] . "</p>";
        
        // Test query installations
        $query = "SELECT COUNT(*) as total FROM installations";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>🔧 Total Installations:</strong> " . $result['total'] . "</p>";
        
        // Test query activity logs
        $query = "SELECT COUNT(*) as total FROM activity_logs";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>📝 Total Activity Logs:</strong> " . $result['total'] . "</p>";
        
        // Test data users
        $query = "SELECT username, full_name, role FROM users LIMIT 5";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h6 class='mt-4'>👥 Data Users:</h6>";
        echo "<table class='table table-sm'>";
        echo "<thead><tr><th>Username</th><th>Nama</th><th>Role</th></tr></thead>";
        echo "<tbody>";
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>" . $user['username'] . "</td>";
            echo "<td>" . $user['full_name'] . "</td>";
            echo "<td><span class='badge bg-primary'>" . ucfirst($user['role']) . "</span></td>";
            echo "</tr>";
        }
        echo "</tbody></table>";
        
        // Test data customers
        $query = "SELECT nama_lengkap, status, created_at FROM customers LIMIT 5";
        $stmt = $db->prepare($query);
        $stmt->execute();
        $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h6 class='mt-4'>👤 Data Customers:</h6>";
        echo "<table class='table table-sm'>";
        echo "<thead><tr><th>Nama</th><th>Status</th><th>Tanggal</th></tr></thead>";
        echo "<tbody>";
        foreach ($customers as $customer) {
            $status_class = '';
            switch ($customer['status']) {
                case 'pending': $status_class = 'warning'; break;
                case 'approved': $status_class = 'info'; break;
                case 'installed': $status_class = 'success'; break;
                case 'cancelled': $status_class = 'danger'; break;
                default: $status_class = 'secondary';
            }
            echo "<tr>";
            echo "<td>" . $customer['nama_lengkap'] . "</td>";
            echo "<td><span class='badge bg-" . $status_class . "'>" . ucfirst($customer['status']) . "</span></td>";
            echo "<td>" . date('d/m/Y', strtotime($customer['created_at'])) . "</td>";
            echo "</tr>";
        }
        echo "</tbody></table>";
        
        echo "<div class='alert alert-info mt-4'>";
        echo "<h6><i class='fas fa-info-circle me-2'></i>Informasi:</h6>";
        echo "<ul class='mb-0'>";
        echo "<li>Database: ensia_db</li>";
        echo "<li>Host: localhost</li>";
        echo "<li>Status: Connected</li>";
        echo "<li>Data sample sudah terimport dengan alamat Sukabumi</li>";
        echo "</ul>";
        echo "</div>";
        
        echo "<div class='text-center mt-4'>";
        echo "<a href='login.php' class='btn btn-primary me-2'>";
        echo "<i class='fas fa-sign-in-alt me-2'></i>Masuk ke Aplikasi";
        echo "</a>";
        echo "<a href='login_info.html' class='btn btn-outline-info'>";
        echo "<i class='fas fa-info-circle me-2'></i>Info Login";
        echo "</a>";
        echo "</div>";
        
    } else {
        echo "<div class='alert alert-danger'>";
        echo "<h5><i class='fas fa-exclamation-triangle me-2'></i>❌ Koneksi Database Gagal!</h5>";
        echo "<p>Periksa konfigurasi database di file config/database.php</p>";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>";
    echo "<h5><i class='fas fa-exclamation-triangle me-2'></i>❌ Error Database!</h5>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<p>Periksa:</p>";
    echo "<ul>";
    echo "<li>MySQL service berjalan</li>";
    echo "<li>Database ensia_db sudah dibuat</li>";
    echo "<li>Konfigurasi database benar</li>";
    echo "<li>User memiliki akses ke database</li>";
    echo "</ul>";
    echo "</div>";
}

echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";

echo "<script src='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js'></script>";
echo "<script src='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js'></script>";
echo "</body>";
echo "</html>";
?>
