<?php
require_once 'config/config.php';
requireRole(['teknisi']);

$database = new Database();
$db = $database->getConnection();

// Handle AJAX form submission
if ($_POST && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    
    $nama_lengkap = sanitizeInput($_POST['nama_lengkap']);
    $pekerjaan = sanitizeInput($_POST['pekerjaan']);
    $alamat_lengkap = sanitizeInput($_POST['alamat_lengkap']);
    $nomor_hp = sanitizeInput($_POST['nomor_hp']);
    $email = sanitizeInput($_POST['email']);
    $nik_ktp = sanitizeInput($_POST['nik_ktp']);
    $paket_internet = sanitizeInput($_POST['paket_internet']);
    $harga_paket = (int)$_POST['harga_paket'];
    $catatan_instalasi = sanitizeInput($_POST['catatan_instalasi']);
    
    $response = ['success' => false, 'message' => ''];
    
    // Handle upload foto KTP
    $foto_ktp = '';
    if (isset($_FILES['foto_ktp']) && $_FILES['foto_ktp']['error'] == 0) {
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png'];
        $max_size = 5 * 1024 * 1024; // 5MB
        
        if (in_array($_FILES['foto_ktp']['type'], $allowed_types) && $_FILES['foto_ktp']['size'] <= $max_size) {
            $file_extension = pathinfo($_FILES['foto_ktp']['name'], PATHINFO_EXTENSION);
            $foto_ktp = 'ktp_' . time() . '_' . $nik_ktp . '.' . $file_extension;
            $upload_path = 'uploads/ktp/' . $foto_ktp;
            
            if (!move_uploaded_file($_FILES['foto_ktp']['tmp_name'], $upload_path)) {
                $response['message'] = 'Gagal mengupload foto KTP!';
                echo json_encode($response);
                exit;
            }
        } else {
            $response['message'] = 'Format foto KTP tidak valid! Gunakan JPG/PNG maksimal 5MB.';
            echo json_encode($response);
            exit;
        }
    }
    
    try {
        // Insert customer data
        $query = "INSERT INTO customers (nama_lengkap, pekerjaan, alamat_lengkap, nomor_hp, email, nik_ktp, foto_ktp, paket_internet, harga_paket, catatan_instalasi, created_by, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$nama_lengkap, $pekerjaan, $alamat_lengkap, $nomor_hp, $email, $nik_ktp, $foto_ktp, $paket_internet, $harga_paket, $catatan_instalasi, $_SESSION['user_id']])) {
            $response['success'] = true;
            $response['message'] = 'Data pelanggan berhasil ditambahkan! Status: Pending (menunggu persetujuan supervisor)';
            
            // Log activity
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'create', 'Menambahkan data pelanggan baru', 'customers', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $db->lastInsertId()]);
        } else {
            $response['message'] = 'Gagal menambahkan data pelanggan!';
        }
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
    
    echo json_encode($response);
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Data Pelanggan - Teknisi - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="responsive_design.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .main-content {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin: 2rem 0;
        }
        .form-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .form-section h5 {
            color: #667eea;
            margin-bottom: 1rem;
            border-bottom: 2px solid #667eea;
            padding-bottom: 0.5rem;
        }
        .btn-submit {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        .btn-submit:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }
        .btn-submit:disabled:hover {
            transform: none;
            box-shadow: none;
        }
        .form-label {
            font-weight: 600;
            color: #333;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .required {
            color: #dc3545;
        }
        .foto-preview {
            max-width: 200px;
            max-height: 150px;
            border-radius: 8px;
        }
        .paket-option {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .paket-option:hover {
            border-color: #667eea;
            background: #f8f9fa;
        }
        .paket-option.selected {
            border-color: #667eea;
            background: #e3f2fd;
        }
        .paket-option input[type="radio"] {
            margin-right: 0.5rem;
        }
        .paket-option h6 {
            margin-bottom: 0.5rem;
            color: #667eea;
        }
        .paket-option .price {
            font-size: 1.2rem;
            font-weight: bold;
            color: #28a745;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
        .loading-spinner {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        .spinner-border {
            width: 3rem;
            height: 3rem;
            border-width: 0.3em;
        }
        .form-control:invalid {
            border-color: #dc3545;
        }
        .form-control:valid {
            border-color: #28a745;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar">
                <div class="sidebar-content">
                    <div class="logo-section">
                        <img src="https://via.placeholder.com/150x50/667eea/ffffff?text=Majuin" alt="Majuin Logo" class="logo">
                    </div>
                    <nav class="nav flex-column">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link active" href="teknisi_add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="installations.php">
                            <i class="fas fa-tools me-2"></i>Instalasi
                        </a>
                        <a class="nav-link" href="installed_customers.php">
                            <i class="fas fa-check-circle me-2"></i>Pelanggan Selesai
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 main-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-user-plus me-2"></i>Tambah Data Pelanggan</h2>
                    <span class="badge bg-info fs-6">Teknisi</span>
                </div>
                
                <!-- Alert akan muncul via JavaScript -->
                
                <form id="customerForm" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="ajax" value="1">
                    <!-- Data Pribadi -->
                    <div class="form-section">
                        <h5><i class="fas fa-user me-2"></i>Data Pribadi</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="nama_lengkap" class="form-label">Nama Lengkap <span class="required">*</span></label>
                                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="pekerjaan" class="form-label">Pekerjaan <span class="required">*</span></label>
                                <input type="text" class="form-control" id="pekerjaan" name="pekerjaan" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="nomor_hp" class="form-label">Nomor HP <span class="required">*</span></label>
                                <input type="tel" class="form-control" id="nomor_hp" name="nomor_hp" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">Email <span class="required">*</span></label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="nik_ktp" class="form-label">NIK KTP <span class="required">*</span></label>
                                <input type="text" class="form-control" id="nik_ktp" name="nik_ktp" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="foto_ktp" class="form-label">Foto KTP</label>
                                <input type="file" class="form-control" id="foto_ktp" name="foto_ktp" accept="image/jpeg,image/jpg,image/png">
                                <div class="form-text">Format: JPG/PNG, maksimal 5MB</div>
                                <div id="foto-preview" class="mt-2" style="display: none;">
                                    <img id="preview-img" src="" alt="Preview Foto KTP" class="foto-preview">
                                    <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="removeFoto()">
                                        <i class="fas fa-times me-1"></i>Hapus
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Alamat -->
                    <div class="form-section">
                        <h5><i class="fas fa-map-marker-alt me-2"></i>Alamat</h5>
                        <div class="mb-3">
                            <label for="alamat_lengkap" class="form-label">Alamat Lengkap <span class="required">*</span></label>
                            <textarea class="form-control" id="alamat_lengkap" name="alamat_lengkap" rows="3" required></textarea>
                        </div>
                    </div>
                    
                    <!-- Paket Internet -->
                    <div class="form-section">
                        <h5><i class="fas fa-wifi me-2"></i>Paket Internet</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="paket-option" onclick="selectPaket('Basic', 150000)">
                                    <input type="radio" name="paket_internet" value="Basic" id="paket_basic">
                                    <h6>Paket Basic</h6>
                                    <p class="mb-1">Kecepatan: 10 Mbps</p>
                                    <p class="mb-1">Kuota: Unlimited</p>
                                    <p class="price">Rp 150.000/bulan</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="paket-option" onclick="selectPaket('Standard', 250000)">
                                    <input type="radio" name="paket_internet" value="Standard" id="paket_standard">
                                    <h6>Paket Standard</h6>
                                    <p class="mb-1">Kecepatan: 25 Mbps</p>
                                    <p class="mb-1">Kuota: Unlimited</p>
                                    <p class="price">Rp 250.000/bulan</p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="paket-option" onclick="selectPaket('Premium', 400000)">
                                    <input type="radio" name="paket_internet" value="Premium" id="paket_premium">
                                    <h6>Paket Premium</h6>
                                    <p class="mb-1">Kecepatan: 50 Mbps</p>
                                    <p class="mb-1">Kuota: Unlimited</p>
                                    <p class="price">Rp 400.000/bulan</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="paket-option" onclick="selectPaket('Business', 600000)">
                                    <input type="radio" name="paket_internet" value="Business" id="paket_business">
                                    <h6>Paket Business</h6>
                                    <p class="mb-1">Kecepatan: 100 Mbps</p>
                                    <p class="mb-1">Kuota: Unlimited</p>
                                    <p class="price">Rp 600.000/bulan</p>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="harga_paket" name="harga_paket" value="">
                    </div>
                    
                    <!-- Catatan Instalasi -->
                    <div class="form-section">
                        <h5><i class="fas fa-sticky-note me-2"></i>Catatan Instalasi</h5>
                        <div class="mb-3">
                            <label for="catatan_instalasi" class="form-label">Catatan Khusus</label>
                            <textarea class="form-control" id="catatan_instalasi" name="catatan_instalasi" rows="3" placeholder="Catatan khusus untuk instalasi (opsional)"></textarea>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div class="text-center">
                        <button type="submit" class="btn btn-submit btn-lg">
                            <i class="fas fa-save me-2"></i>Simpan Data Pelanggan
                        </button>
                        <a href="installations.php" class="btn btn-outline-secondary btn-lg ms-3">
                            <i class="fas fa-arrow-left me-2"></i>Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="loading-spinner">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-3 mb-0">Menyimpan data pelanggan...</p>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Foto KTP preview
        document.getElementById('foto_ktp').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('foto-preview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        function removeFoto() {
            document.getElementById('foto_ktp').value = '';
            document.getElementById('foto-preview').style.display = 'none';
        }
        
        // Paket selection
        function selectPaket(paket, harga) {
            // Remove selected class from all options
            document.querySelectorAll('.paket-option').forEach(option => {
                option.classList.remove('selected');
            });
            
            // Add selected class to clicked option
            event.currentTarget.classList.add('selected');
            
            // Set hidden input value
            document.getElementById('harga_paket').value = harga;
        }
        
        // AJAX Form submission
        document.getElementById('customerForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const paket = document.querySelector('input[name="paket_internet"]:checked');
            if (!paket) {
                showAlert('Pilih paket internet terlebih dahulu!', 'danger');
                return false;
            }
            
            // Show loading overlay
            document.getElementById('loadingOverlay').style.display = 'flex';
            
            // Create FormData
            const formData = new FormData(this);
            
            // Send AJAX request
            fetch('teknisi_add_customer.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert(data.message, 'success');
                    // Reset form
                    document.getElementById('customerForm').reset();
                    document.querySelectorAll('.paket-option').forEach(option => {
                        option.classList.remove('selected');
                    });
                    document.getElementById('foto-preview').style.display = 'none';
                } else {
                    showAlert(data.message, 'danger');
                }
            })
            .catch(error => {
                showAlert('Terjadi kesalahan: ' + error.message, 'danger');
            })
            .finally(() => {
                // Hide loading overlay
                document.getElementById('loadingOverlay').style.display = 'none';
            });
        });
        
        // Show alert function
        function showAlert(message, type) {
            // Remove existing alerts
            const existingAlerts = document.querySelectorAll('.alert');
            existingAlerts.forEach(alert => alert.remove());
            
            // Create new alert
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            // Insert alert after header
            const header = document.querySelector('.d-flex.justify-content-between.align-items-center.mb-4');
            header.insertAdjacentElement('afterend', alertDiv);
            
            // Auto dismiss after 5 seconds
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 5000);
        }
    </script>
</body>
</html>
