<?php
// Status Aplikasi ENSIA
// Engineer On Site App (ENSIA) PT Maintek Juara Intisolusi

echo "<!DOCTYPE html>";
echo "<html lang='id'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Status Aplikasi - ENSIA</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css' rel='stylesheet'>";
echo "<style>";
echo "body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }";
echo ".status-card { background: white; border-radius: 15px; box-shadow: 0 15px 35px rgba(0,0,0,0.1); padding: 2rem; margin: 1rem 0; }";
echo ".status-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 1.5rem; border-radius: 10px; margin-bottom: 2rem; }";
echo ".feature-item { padding: 0.5rem 0; border-bottom: 1px solid #f8f9fa; }";
echo ".feature-item:last-child { border-bottom: none; }";
echo "</style>";
echo "</head>";
echo "<body>";

echo "<div class='container py-4'>";
echo "<div class='row justify-content-center'>";
echo "<div class='col-md-10'>";

// Header
echo "<div class='status-header text-center'>";
echo "<div class='d-flex align-items-center justify-content-center mb-3'>";
echo "<i class='fas fa-wifi fa-3x me-3'></i>";
echo "<div>";
echo "<h2 class='mb-1'>Engineer On Site App (ENSIA)</h2>";
echo "<p class='mb-0'>PT Maintek Juara Intisolusi</p>";
echo "</div>";
echo "</div>";
echo "</div>";

// Status Aplikasi
echo "<div class='status-card'>";
echo "<h4 class='mb-4'><i class='fas fa-chart-line me-2'></i>Status Aplikasi</h4>";

$status_items = [
    ['icon' => 'fas fa-database', 'title' => 'Database MySQL', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-code', 'title' => 'PHP Backend', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-palette', 'title' => 'UI/UX Design', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-shield-alt', 'title' => 'Security System', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-file-pdf', 'title' => 'PDF Export', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-file-excel', 'title' => 'Excel Export', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-map-marker-alt', 'title' => 'GPS Tracking', 'status' => 'Ready', 'class' => 'success'],
    ['icon' => 'fas fa-chart-bar', 'title' => 'Reports & Analytics', 'status' => 'Ready', 'class' => 'success']
];

foreach ($status_items as $item) {
    echo "<div class='feature-item d-flex justify-content-between align-items-center'>";
    echo "<div class='d-flex align-items-center'>";
    echo "<i class='{$item['icon']} me-3 text-primary'></i>";
    echo "<span class='fw-bold'>{$item['title']}</span>";
    echo "</div>";
    echo "<span class='badge bg-{$item['class']}'>{$item['status']}</span>";
    echo "</div>";
}
echo "</div>";

// File Structure
echo "<div class='status-card'>";
echo "<h4 class='mb-4'><i class='fas fa-folder-tree me-2'></i>Struktur Aplikasi</h4>";

$files = [
    ['name' => 'login.php', 'desc' => 'Halaman Login dengan Email Fake', 'size' => '5.9 KB'],
    ['name' => 'dashboard.php', 'desc' => 'Dashboard dengan Statistik & Grafik', 'size' => '12.3 KB'],
    ['name' => 'customers.php', 'desc' => 'Manajemen Data Pelanggan', 'size' => '17.2 KB'],
    ['name' => 'add_customer.php', 'desc' => 'Tambah Data Pelanggan', 'size' => '12.7 KB'],
    ['name' => 'customer_edit.php', 'desc' => 'Edit Data Pelanggan', 'size' => '13.3 KB'],
    ['name' => 'customer_detail.php', 'desc' => 'Detail Pelanggan & Log', 'size' => '20.9 KB'],
    ['name' => 'customer_print.php', 'desc' => 'Print PDF Pelanggan', 'size' => '7.4 KB'],
    ['name' => 'approvals.php', 'desc' => 'Persetujuan Supervisor', 'size' => '23.3 KB'],
    ['name' => 'installations.php', 'desc' => 'Instalasi Teknisi dengan GPS', 'size' => '34.0 KB'],
    ['name' => 'reports.php', 'desc' => 'Laporan & Export Excel/PDF', 'size' => '27.7 KB'],
    ['name' => 'test_db.php', 'desc' => 'Test Koneksi Database', 'size' => '6.6 KB'],
    ['name' => 'setup_database.php', 'desc' => 'Setup Database Otomatis', 'size' => '6.3 KB']
];

echo "<div class='row'>";
foreach ($files as $file) {
    echo "<div class='col-md-6 mb-3'>";
    echo "<div class='card h-100'>";
    echo "<div class='card-body'>";
    echo "<h6 class='card-title'><i class='fas fa-file-code me-2'></i>{$file['name']}</h6>";
    echo "<p class='card-text text-muted'>{$file['desc']}</p>";
    echo "<small class='text-muted'>{$file['size']}</small>";
    echo "</div>";
    echo "</div>";
    echo "</div>";
}
echo "</div>";
echo "</div>";

// Data Sample
echo "<div class='status-card'>";
echo "<h4 class='mb-4'><i class='fas fa-database me-2'></i>Data Sample Sukabumi</h4>";

$data_items = [
    ['icon' => 'fas fa-users', 'title' => 'Users (Admin, Supervisor, Teknisi)', 'count' => '5', 'desc' => 'Email fake untuk login'],
    ['icon' => 'fas fa-user-friends', 'title' => 'Customers', 'count' => '9', 'desc' => 'Alamat lengkap di Sukabumi'],
    ['icon' => 'fas fa-tools', 'title' => 'Installations', 'count' => '4', 'desc' => 'Dengan koordinat GPS Sukabumi'],
    ['icon' => 'fas fa-history', 'title' => 'Activity Logs', 'count' => '16', 'desc' => 'Tracking aktivitas sistem']
];

foreach ($data_items as $item) {
    echo "<div class='feature-item d-flex justify-content-between align-items-center'>";
    echo "<div class='d-flex align-items-center'>";
    echo "<i class='{$item['icon']} me-3 text-info'></i>";
    echo "<div>";
    echo "<span class='fw-bold'>{$item['title']}</span>";
    echo "<br><small class='text-muted'>{$item['desc']}</small>";
    echo "</div>";
    echo "</div>";
    echo "<span class='badge bg-primary fs-6'>{$item['count']}</span>";
    echo "</div>";
}
echo "</div>";

// Login Info
echo "<div class='status-card'>";
echo "<h4 class='mb-4'><i class='fas fa-key me-2'></i>Informasi Login</h4>";

$login_accounts = [
    ['role' => 'Admin', 'email' => 'admin@ensia.com', 'password' => 'password', 'class' => 'danger'],
    ['role' => 'Manager', 'email' => 'manager@ensia.com', 'password' => 'password', 'class' => 'danger'],
    ['role' => 'Supervisor', 'email' => 'supervisor@ensia.com', 'password' => 'password', 'class' => 'warning'],
    ['role' => 'Teknisi 1', 'email' => 'teknisi1@ensia.com', 'password' => 'password', 'class' => 'info'],
    ['role' => 'Teknisi 2', 'email' => 'teknisi2@ensia.com', 'password' => 'password', 'class' => 'info']
];

foreach ($login_accounts as $account) {
    echo "<div class='feature-item d-flex justify-content-between align-items-center'>";
    echo "<div class='d-flex align-items-center'>";
    echo "<span class='badge bg-{$account['class']} me-3'>{$account['role']}</span>";
    echo "<span class='fw-bold'>{$account['email']}</span>";
    echo "</div>";
    echo "<span class='text-muted'>{$account['password']}</span>";
    echo "</div>";
}
echo "</div>";

// Quick Actions
echo "<div class='status-card'>";
echo "<h4 class='mb-4'><i class='fas fa-rocket me-2'></i>Quick Actions</h4>";
echo "<div class='row'>";
echo "<div class='col-md-4 mb-2'>";
echo "<a href='setup_database.php' class='btn btn-primary w-100'>";
echo "<i class='fas fa-database me-2'></i>Setup Database";
echo "</a>";
echo "</div>";
echo "<div class='col-md-4 mb-2'>";
echo "<a href='test_db.php' class='btn btn-info w-100'>";
echo "<i class='fas fa-check-circle me-2'></i>Test Database";
echo "</a>";
echo "</div>";
echo "<div class='col-md-4 mb-2'>";
echo "<a href='login.php' class='btn btn-success w-100'>";
echo "<i class='fas fa-sign-in-alt me-2'></i>Login Aplikasi";
echo "</a>";
echo "</div>";
echo "</div>";
echo "<div class='row mt-2'>";
echo "<div class='col-md-6 mb-2'>";
echo "<a href='login_info.html' class='btn btn-outline-primary w-100'>";
echo "<i class='fas fa-info-circle me-2'></i>Info Login";
echo "</a>";
echo "</div>";
echo "<div class='col-md-6 mb-2'>";
echo "<a href='README.md' class='btn btn-outline-secondary w-100'>";
echo "<i class='fas fa-book me-2'></i>Dokumentasi";
echo "</a>";
echo "</div>";
echo "</div>";
echo "</div>";

// Footer
echo "<div class='text-center mt-4'>";
echo "<p class='text-white'>";
echo "<strong>Developed by Amiruloh</strong><br>";
echo "Tugas Akhir D3 Manajemen Informatika<br>";
echo "AMIK CBI Sukabumi";
echo "</p>";
echo "</div>";

echo "</div>";
echo "</div>";
echo "</div>";

echo "<script src='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js'></script>";
echo "</body>";
echo "</html>";
?>
