<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Formulir Pendaftaran Internet - ENSIA</title>
    <!-- Memuat Tailwind CSS untuk styling -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Memuat Google Fonts: Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Menggunakan font Inter sebagai default */
        body {
            font-family: 'Inter', sans-serif;
        }
        /* Style kustom untuk radio button agar lebih menarik */
        .form-radio {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            display: inline-block;
            position: relative;
            background-color: #f9fafb;
            color: #374151;
            top: 5px;
            height: 1.5rem;
            width: 1.5rem;
            border: 1px solid #d1d5db;
            border-radius: 50%;
            cursor: pointer;
            margin-right: 0.5rem;
            outline: none;
        }
        .form-radio:checked {
            background-color: #3b82f6;
            border-color: #3b82f6;
        }
        .form-radio:checked::before {
            content: '';
            display: block;
            width: 0.75rem;
            height: 0.75rem;
            background-color: white;
            border-radius: 50%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        .form-radio:hover {
            border-color: #9ca3af;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
    </style>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen p-4">

    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="bg-yellow-400 text-black px-3 py-1 rounded-full text-sm font-bold">
            <i class="fas fa-flask mr-1"></i>DEMO
        </span>
    </div>

    <div class="w-full max-w-4xl bg-white shadow-lg rounded-lg overflow-hidden">
        <!-- Bagian Header -->
        <header class="p-4 grid grid-cols-3 items-center border-b">
            <div class="flex items-center">
                <!-- Ganti '#' dengan path logo Anda -->
                <img src="https://placehold.co/40x40/0284C7/FFFFFF?text=M" alt="Logo Majuin" class="h-10 w-10 mr-2">
                <div>
                    <h1 class="font-bold text-lg text-blue-700">MAJUIN</h1>
                    <p class="text-xs text-gray-600">PT Maintek Juara Inti Solusi</p>
                </div>
            </div>
            <div class="text-center">
                 <p class="text-sm font-semibold">Powered By:</p>
                 <!-- Ganti '#' dengan path logo Anda -->
                 <img src="https://placehold.co/120x40/FBBF24/000000?text=RSTN+Net" alt="Logo RSTN" class="h-10 mx-auto">
            </div>
            <div class="text-right">
                <div class="bg-blue-700 text-white p-3 rounded-lg inline-block">
                    <p class="text-sm font-semibold">Customer Care</p>
                    <p class="text-lg font-bold">(MAJUIN)</p>
                    <p class="text-xl font-bold">0817 228 297</p>
                </div>
            </div>
        </header>

        <!-- Bagian Judul Formulir -->
        <div class="bg-yellow-400 p-3 my-4 mx-4 rounded-md">
            <h2 class="text-center text-2xl font-bold text-gray-800">Formulir Pendaftaran Internet</h2>
            <p class="text-center text-sm mt-1">Demo - Teknisi Input Data Pelanggan</p>
        </div>

        <!-- Bagian Formulir Utama -->
        <main class="p-6">
            <form id="customerForm">
                <!-- Baris Pertama: Sektor, No Register, Tanggal -->
                <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-4 items-center">
                    <div class="md:col-span-4 flex items-center">
                        <label for="sektor" class="w-1/3 font-semibold text-gray-700">Sektor</label>
                        <input type="text" id="sektor" name="sektor" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Cikole" readonly>
                    </div>
                    <div class="md:col-span-4 flex items-center">
                        <label for="no_register" class="w-1/3 font-semibold text-gray-700">No Register</label>
                        <input type="text" id="no_register" name="no_register" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="REG-2024-001" readonly>
                    </div>
                    <div class="md:col-span-4 flex items-center">
                        <label for="tanggal" class="font-semibold text-gray-700 mr-2">Tanggal</label>
                        <input type="date" id="tanggal" name="tanggal" class="bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="2024-01-15" readonly>
                    </div>
                </div>

                <!-- Baris Nama Lengkap & Panggilan -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div class="flex items-center">
                        <label for="nama_lengkap" class="w-1/4 font-semibold text-gray-700">Nama Lengkap</label>
                        <input type="text" id="nama_lengkap" name="nama_lengkap" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Budi Santoso" readonly>
                    </div>
                    <div class="flex items-center">
                        <label for="nama_panggilan" class="w-1/4 font-semibold text-gray-700">Nama Panggilan</label>
                        <input type="text" id="nama_panggilan" name="nama_panggilan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Budi" readonly>
                    </div>
                </div>

                <!-- Input Lainnya -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <label for="alamat_ktp" class="w-[16.66%] font-semibold text-gray-700">Alamat KTP</label>
                        <input type="text" id="alamat_ktp" name="alamat_ktp" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi" readonly>
                    </div>
                    <div class="flex items-center">
                        <label for="alamat_pemasangan" class="w-[16.66%] font-semibold text-gray-700">Alamat Pemasangan</label>
                        <input type="text" id="alamat_pemasangan" name="alamat_pemasangan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Jl. Merdeka No. 123, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi" readonly>
                    </div>
                     <div class="flex items-center">
                        <label for="nomor_identitas" class="w-[16.66%] font-semibold text-gray-700">Nomor Identitas</label>
                        <input type="text" id="nomor_identitas" name="nomor_identitas" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="3201234567890123" readonly>
                    </div>
                     <div class="flex items-center">
                        <label for="pekerjaan" class="w-[16.66%] font-semibold text-gray-700">Pekerjaan</label>
                        <input type="text" id="pekerjaan" name="pekerjaan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Wiraswasta" readonly>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="no_hp1" class="w-1/4 font-semibold text-gray-700">No Hp 1</label>
                            <input type="tel" id="no_hp1" name="no_hp1" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="081234567897" readonly>
                        </div>
                        <div class="flex items-center">
                            <label for="no_hp2" class="w-1/4 font-semibold text-gray-700">No Hp 2</label>
                            <input type="tel" id="no_hp2" name="no_hp2" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="081234567898" readonly>
                        </div>
                    </div>

                    <!-- Upload Foto KTP -->
                    <div class="flex items-center">
                        <label for="foto_ktp" class="w-[16.66%] font-semibold text-gray-700">Foto KTP</label>
                        <div class="flex-1">
                            <input type="file" id="foto_ktp" name="foto_ktp" accept="image/jpeg,image/jpg,image/png" class="bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" disabled>
                            <div class="text-xs text-gray-500 mt-1">Format: JPG/PNG, maksimal 5MB</div>
                            <div class="mt-2">
                                <img src="https://via.placeholder.com/128x96/667eea/ffffff?text=KTP+Preview" alt="Preview Foto KTP" class="w-32 h-24 object-cover rounded border">
                                <button type="button" class="ml-2 text-red-500 text-sm" disabled>Hapus</button>
                            </div>
                        </div>
                    </div>

                    <!-- Pilihan Paket -->
                    <div class="flex items-center">
                        <label class="w-[16.66%] font-semibold text-gray-700">Pilihan Paket</label>
                        <div class="flex-1 flex items-center space-x-6">
                            <label class="flex items-center"><input type="radio" name="paket" value="10" class="form-radio" disabled> 10 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="15" class="form-radio" checked disabled> 15 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="20" class="form-radio" disabled> 20 mb</label>
                            <label class="flex items-center"><input type="radio" name="paket" value="30" class="form-radio" disabled> 30 mb</label>
                        </div>
                         <label for="jenis_modem" class="font-semibold text-gray-700 ml-4 mr-2">Jenis Modem</label>
                         <input type="text" id="jenis_modem" name="jenis_modem" class="w-1/4 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5" value="TP-Link Archer C6" readonly>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="nama_wifi" class="w-1/4 font-semibold text-gray-700">Nama Wifi</label>
                            <input type="text" id="nama_wifi" name="nama_wifi" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="MAJUIN-BUDI" readonly>
                        </div>
                        <div class="flex items-center">
                            <label for="password" class="w-1/4 font-semibold text-gray-700">Password</label>
                            <input type="password" id="password" name="password" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="password123" readonly>
                        </div>
                    </div>
                     <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-center">
                        <div class="md:col-span-4 flex items-center">
                           <label for="status_rumah" class="w-1/2 font-semibold text-gray-700">Status Rumah</label>
                           <input type="text" id="status_rumah" name="status_rumah" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Milik Sendiri" readonly>
                        </div>
                         <div class="md:col-span-4 flex items-center">
                           <label for="jarak" class="w-1/3 font-semibold text-gray-700">Jarak</label>
                           <input type="text" id="jarak" name="jarak" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="50 meter" readonly>
                        </div>
                        <div class="md:col-span-4 flex items-center">
                           <label for="id_pelanggan" class="w-1/2 font-semibold text-gray-700">ID Pelanggan</label>
                           <input type="text" id="id_pelanggan" name="id_pelanggan" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="CUST-2024-001" readonly>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="flex items-center">
                            <label for="biaya_pendaftaran" class="w-1/2 font-semibold text-gray-700">Biaya Pendaftaran</label>
                            <input type="text" id="biaya_pendaftaran" name="biaya_pendaftaran" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Rp 200.000" readonly>
                        </div>
                        <div class="flex items-center">
                           <label for="status_bayar" class="w-1/3 font-semibold text-gray-700">Status Bayar</label>
                            <input type="text" id="status_bayar" name="status_bayar" class="flex-1 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" value="Lunas" readonly>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="text-center mt-8">
                    <button type="button" class="bg-blue-700 hover:bg-blue-800 text-white font-bold py-3 px-8 rounded-lg text-lg transition duration-300 ease-in-out transform hover:scale-105" onclick="simulateSubmit()">
                        <i class="fas fa-save mr-2"></i>Simpan Data Pelanggan
                    </button>
                    <a href="demo_installations.php" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-8 rounded-lg text-lg transition duration-300 ease-in-out transform hover:scale-105 ml-4">
                        <i class="fas fa-arrow-left mr-2"></i>Kembali ke Instalasi
                    </a>
                </div>
            </form>
        </main>

        <!-- Bagian Syarat & Ketentuan -->
        <section class="p-6 border-t">
            <h3 class="font-bold text-center text-lg mb-4">Terms of Service & Disclaimer</h3>
            <ol class="list-decimal list-inside text-sm text-gray-700 space-y-2">
                <li>Dilarang digunakan untuk akses semua layanan/website yang dilarang Kominfo & Tindak pidana, Seperti Website Pornografi, kekerasan, Judi Online, dan Teroris, Serta lain sebagainya yang melanggar menurut aturan perundang-undangan Negara Republik Indonesia.</li>
                <li>Dilarang dijual kembali baik Paralel atau FTTH tanpa seizin penyedia layanan ISP.</li>
                <li>Tidak Boleh memodifikasi atau merubah pengaturan dari modem & kabel distribusi.</li>
                <li>Pihak ISP tidak bertanggung jawab untuk segala pelanggaran yang dilanggar oleh pengguna layanan (Pelanggan).</li>
                <li>Pembayaran maksimal Tanggal 10 Setiap Bulannya, Bila belum melakukan pembayaran atau tidak konfirmasi maka system akan otomatis isolir/menon-aktifkan pengguna atau user tersebut.</li>
                <li>Peralatan DIPINJAMKAN selama berlangganan, dan hanya HAK PAKAI, Bukan Hak Milik.</li>
                <li>Biaya paket sudah termasuk pajak 11%</li>
            </ol>

            <div class="mt-8 flex justify-between items-end">
                <div>
                    <p class="font-bold">0817-228-297 (Office) / salam@majuin.co.id</p>
                    <p class="font-bold text-blue-600">https://majuin.co.id</p>
                </div>
                <div class="text-center">
                     <p class="font-bold">TTD Berlangganan Wajib</p>
                </div>
            </div>
        </section>

        <!-- Bagian Footer -->
        <footer class="bg-blue-700 text-white p-4 flex justify-between items-center">
            <h3 class="text-xl font-bold">THANK YOU FOR YOUR INFORMATION</h3>
            <span class="bg-blue-900 text-sm py-1 px-3 rounded">Version : 1.0.7</span>
        </footer>
    </div>

    <script>
        function simulateSubmit() {
            alert('Data pelanggan berhasil disimpan!\n\nStatus: Pending (menunggu persetujuan supervisor)\n\nForm menggunakan AJAX - tidak ada refresh halaman!');
        }
    </script>
</body>
</html>
