<?php
// Demo halaman input data pelanggan oleh teknisi tanpa login
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo - Input Data Pelanggan - Teknisi - ENSIA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 2rem 0;
        }
        .header {
            text-align: center;
            color: white;
            margin-bottom: 2rem;
        }
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .demo-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        .demo-badge {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
        .feature-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .feature-card h6 {
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        .form-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .form-section h5 {
            color: #667eea;
            margin-bottom: 1rem;
            border-bottom: 2px solid #667eea;
            padding-bottom: 0.5rem;
        }
        .paket-option {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .paket-option:hover {
            border-color: #667eea;
            background: #f8f9fa;
        }
        .paket-option.selected {
            border-color: #667eea;
            background: #e3f2fd;
        }
        .paket-option h6 {
            margin-bottom: 0.5rem;
            color: #667eea;
        }
        .paket-option .price {
            font-size: 1.2rem;
            font-weight: bold;
            color: #28a745;
        }
        .btn-demo {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-demo:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        .form-label {
            font-weight: 600;
            color: #333;
        }
        .required {
            color: #dc3545;
        }
        .foto-preview {
            max-width: 200px;
            max-height: 150px;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <!-- Demo Badge -->
    <div class="demo-badge">
        <span class="badge bg-warning fs-6">
            <i class="fas fa-flask me-1"></i>DEMO
        </span>
    </div>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class="fas fa-wifi me-3"></i>ENSIA</h1>
            <p>Engineer On Site App - PT Maintek Juara Intisolusi</p>
            <h3>🔧 Demo - Input Data Pelanggan oleh Teknisi</h3>
            <p class="lead">Teknisi dapat input data pelanggan yang daftar internet langsung di lapangan</p>
        </div>
        
        <!-- Features Info -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-user-plus me-2"></i>Input Data Lengkap</h6>
                    <p class="text-muted small mb-0">Data pribadi, alamat, dan paket internet</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-camera me-2"></i>Upload KTP</h6>
                    <p class="text-muted small mb-0">Upload foto KTP dengan preview</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-wifi me-2"></i>Pilih Paket</h6>
                    <p class="text-muted small mb-0">4 pilihan paket internet dengan harga</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="feature-card">
                    <h6><i class="fas fa-sticky-note me-2"></i>Catatan Instalasi</h6>
                    <p class="text-muted small mb-0">Catatan khusus untuk instalasi</p>
                </div>
            </div>
        </div>
        
        <!-- Demo Form -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-edit me-2"></i>Form Input Data Pelanggan
                <span class="badge bg-primary ms-2">Teknisi</span>
            </h4>
            
            <form>
                <!-- Data Pribadi -->
                <div class="form-section">
                    <h5><i class="fas fa-user me-2"></i>Data Pribadi</h5>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nama_lengkap" class="form-label">Nama Lengkap <span class="required">*</span></label>
                            <input type="text" class="form-control" id="nama_lengkap" value="Budi Santoso" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="pekerjaan" class="form-label">Pekerjaan <span class="required">*</span></label>
                            <input type="text" class="form-control" id="pekerjaan" value="Wiraswasta" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nomor_hp" class="form-label">Nomor HP <span class="required">*</span></label>
                            <input type="tel" class="form-control" id="nomor_hp" value="081234567897" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email <span class="required">*</span></label>
                            <input type="email" class="form-control" id="email" value="budi.santoso@email.com" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nik_ktp" class="form-label">NIK KTP <span class="required">*</span></label>
                            <input type="text" class="form-control" id="nik_ktp" value="3201234567890123" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="foto_ktp" class="form-label">Foto KTP</label>
                            <input type="file" class="form-control" id="foto_ktp" accept="image/jpeg,image/jpg,image/png" disabled>
                            <div class="form-text">Format: JPG/PNG, maksimal 5MB</div>
                            <div class="mt-2">
                                <img src="https://via.placeholder.com/200x150/667eea/ffffff?text=KTP+Preview" alt="Preview Foto KTP" class="foto-preview">
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" disabled>
                                    <i class="fas fa-times me-1"></i>Hapus
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Alamat -->
                <div class="form-section">
                    <h5><i class="fas fa-map-marker-alt me-2"></i>Alamat</h5>
                    <div class="mb-3">
                        <label for="alamat_lengkap" class="form-label">Alamat Lengkap <span class="required">*</span></label>
                        <textarea class="form-control" id="alamat_lengkap" rows="3" readonly>Jl. Pahlawan No. 789, Kelurahan Cikole, Kecamatan Cikole, Kota Sukabumi, Jawa Barat 43111</textarea>
                    </div>
                </div>
                
                <!-- Paket Internet -->
                <div class="form-section">
                    <h5><i class="fas fa-wifi me-2"></i>Paket Internet</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="paket-option">
                                <input type="radio" name="paket_internet" value="Basic" id="paket_basic" disabled>
                                <h6>Paket Basic</h6>
                                <p class="mb-1">Kecepatan: 10 Mbps</p>
                                <p class="mb-1">Kuota: Unlimited</p>
                                <p class="price">Rp 150.000/bulan</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="paket-option selected">
                                <input type="radio" name="paket_internet" value="Standard" id="paket_standard" checked disabled>
                                <h6>Paket Standard</h6>
                                <p class="mb-1">Kecepatan: 25 Mbps</p>
                                <p class="mb-1">Kuota: Unlimited</p>
                                <p class="price">Rp 250.000/bulan</p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="paket-option">
                                <input type="radio" name="paket_internet" value="Premium" id="paket_premium" disabled>
                                <h6>Paket Premium</h6>
                                <p class="mb-1">Kecepatan: 50 Mbps</p>
                                <p class="mb-1">Kuota: Unlimited</p>
                                <p class="price">Rp 400.000/bulan</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="paket-option">
                                <input type="radio" name="paket_internet" value="Business" id="paket_business" disabled>
                                <h6>Paket Business</h6>
                                <p class="mb-1">Kecepatan: 100 Mbps</p>
                                <p class="mb-1">Kuota: Unlimited</p>
                                <p class="price">Rp 600.000/bulan</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Catatan Instalasi -->
                <div class="form-section">
                    <h5><i class="fas fa-sticky-note me-2"></i>Catatan Instalasi</h5>
                    <div class="mb-3">
                        <label for="catatan_instalasi" class="form-label">Catatan Khusus</label>
                        <textarea class="form-control" id="catatan_instalasi" rows="3" readonly>Pelanggan meminta instalasi di pagi hari, rumah mudah dijangkau, sudah ada kabel dari tiang listrik</textarea>
                    </div>
                </div>
                
                <!-- Submit Button -->
                <div class="text-center">
                    <button type="button" class="btn btn-demo btn-lg" onclick="simulateSubmit()">
                        <i class="fas fa-save me-2"></i>Simpan Data Pelanggan
                    </button>
                    <a href="demo_installations.php" class="btn btn-outline-secondary btn-lg ms-3">
                        <i class="fas fa-arrow-left me-2"></i>Kembali ke Instalasi
                    </a>
                </div>
            </form>
        </div>
        
        <!-- Features Detail -->
        <div class="row">
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-user-plus me-2 text-success"></i>Input Data Lengkap</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Data pribadi lengkap</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Alamat lengkap</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Kontak (HP, Email)</li>
                        <li><i class="fas fa-check me-2 text-success"></i>NIK KTP</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Foto KTP</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="feature-card">
                    <h6><i class="fas fa-wifi me-2 text-primary"></i>Pilihan Paket Internet</h6>
                    <ul class="list-unstyled small">
                        <li><i class="fas fa-check me-2 text-success"></i>Paket Basic - 10 Mbps - Rp 150.000</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Paket Standard - 25 Mbps - Rp 250.000</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Paket Premium - 50 Mbps - Rp 400.000</li>
                        <li><i class="fas fa-check me-2 text-success"></i>Paket Business - 100 Mbps - Rp 600.000</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Workflow -->
        <div class="demo-card">
            <h4 class="mb-4">
                <i class="fas fa-route me-2"></i>Workflow Teknisi Input Data Pelanggan
            </h4>
            <div class="row">
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-user-plus fa-lg"></i>
                        </div>
                        <h6 class="mt-2">1. Input Data</h6>
                        <p class="small text-muted">Teknisi input data pelanggan lengkap</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-warning text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-clock fa-lg"></i>
                        </div>
                        <h6 class="mt-2">2. Pending</h6>
                        <p class="small text-muted">Status pending, menunggu approval supervisor</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-info text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-check fa-lg"></i>
                        </div>
                        <h6 class="mt-2">3. Approved</h6>
                        <p class="small text-muted">Supervisor approve data pelanggan</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="bg-success text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                            <i class="fas fa-tools fa-lg"></i>
                        </div>
                        <h6 class="mt-2">4. Instalasi</h6>
                        <p class="small text-muted">Teknisi mulai proses instalasi</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="text-center mt-4">
            <p class="text-white">
                <i class="fas fa-code me-2"></i>
                Developed by Amiruloh untuk Tugas Akhir D3 Manajemen Informatika AMIK CBI Sukabumi
            </p>
            <a href="login.php" class="btn btn-light me-2">
                <i class="fas fa-sign-in-alt me-2"></i>Login ke Aplikasi
            </a>
            <a href="demo_installations.php" class="btn btn-outline-light">
                <i class="fas fa-tools me-2"></i>Demo Instalasi
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function simulateSubmit() {
            alert('Data pelanggan berhasil disimpan!\n\nStatus: Pending (menunggu persetujuan supervisor)\n\nData akan muncul di halaman supervisor untuk approval.');
        }
    </script>
</body>
</html>
