<?php
require_once 'config/config.php';
requireRole(['supervisor']);

$database = new Database();
$db = $database->getConnection();

$success = '';
$error = '';

// Handle approval/rejection
if ($_POST && isset($_POST['action']) && isset($_POST['customer_id'])) {
    $customer_id = (int)$_POST['customer_id'];
    $action = $_POST['action'];
    $notes = sanitizeInput($_POST['notes'] ?? '');
    
    if ($action == 'approve') {
        $query = "UPDATE customers SET status = 'approved', approved_by = ?, approved_at = NOW() WHERE id = ? AND status = 'pending'";
        $stmt = $db->prepare($query);
        if ($stmt->execute([$_SESSION['user_id'], $customer_id])) {
            // Log aktivitas
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'approve', 'Menyetujui data pelanggan', 'customers', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $customer_id]);
            
            $success = 'Data pelanggan berhasil disetujui!';
        } else {
            $error = 'Gagal menyetujui data pelanggan!';
        }
    } elseif ($action == 'reject') {
        $query = "UPDATE customers SET status = 'rejected', approved_by = ?, approved_at = NOW() WHERE id = ? AND status = 'pending'";
        $stmt = $db->prepare($query);
        if ($stmt->execute([$_SESSION['user_id'], $customer_id])) {
            // Log aktivitas
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'reject', 'Menolak data pelanggan', 'customers', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $customer_id]);
            
            $success = 'Data pelanggan berhasil ditolak!';
        } else {
            $error = 'Gagal menolak data pelanggan!';
        }
    }
}

// Filter dan pencarian
$search = isset($_GET['search']) ? sanitizeInput($_GET['search']) : '';
$status_filter = isset($_GET['status']) ? sanitizeInput($_GET['status']) : '';

// Query dengan filter
$where_conditions = [];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(c.nama_lengkap LIKE ? OR c.nomor_hp LIKE ? OR c.email LIKE ? OR c.nik_ktp LIKE ?)";
    $search_param = "%$search%";
    $params = array_merge($params, [$search_param, $search_param, $search_param, $search_param]);
}

if (!empty($status_filter)) {
    $where_conditions[] = "c.status = ?";
    $params[] = $status_filter;
} else {
    // Default hanya tampilkan yang pending
    $where_conditions[] = "c.status = 'pending'";
}

$where_clause = 'WHERE ' . implode(' AND ', $where_conditions);

// Query data pelanggan
$query = "SELECT c.*, u.full_name as created_by_name 
          FROM customers c 
          LEFT JOIN users u ON c.created_by = u.id 
          $where_clause 
          ORDER BY c.created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Statistik
$stats_query = "SELECT 
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved,
    SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected
    FROM customers";
$stats_stmt = $db->prepare($stats_query);
$stats_stmt->execute();
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Persetujuan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .filter-card {
            background: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .data-card {
            background: white;
            border-radius: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .customer-card {
            border: 1px solid #dee2e6;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: white;
        }
        .customer-card:hover {
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link active" href="approvals.php">
                            <i class="fas fa-check-circle me-2"></i>Persetujuan
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Persetujuan Data Pelanggan</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <?php if ($success): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i>
                                <?php echo $success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo $error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Statistik -->
                        <div class="row mb-4">
                            <div class="col-md-4 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-warning"><?php echo $stats['pending']; ?></h5>
                                        <p class="card-text">Menunggu Persetujuan</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-success"><?php echo $stats['approved']; ?></h5>
                                        <p class="card-text">Disetujui</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h5 class="card-title text-danger"><?php echo $stats['rejected']; ?></h5>
                                        <p class="card-text">Ditolak</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Filter -->
                        <div class="filter-card">
                            <form method="GET" class="row g-3">
                                <div class="col-md-6">
                                    <label for="search" class="form-label">Pencarian</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           placeholder="Nama, HP, Email, atau NIK..." value="<?php echo $search; ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="status" class="form-label">Status</label>
                                    <select class="form-select" id="status" name="status">
                                        <option value="">Semua Status</option>
                                        <option value="pending" <?php echo $status_filter == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                        <option value="approved" <?php echo $status_filter == 'approved' ? 'selected' : ''; ?>>Approved</option>
                                        <option value="rejected" <?php echo $status_filter == 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary me-2">
                                        <i class="fas fa-search me-2"></i>Cari
                                    </button>
                                    <a href="approvals.php" class="btn btn-outline-secondary">
                                        <i class="fas fa-refresh"></i>
                                    </a>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Data Pelanggan -->
                        <div class="data-card">
                            <?php if (empty($customers)): ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">Tidak ada data pelanggan</p>
                                </div>
                            <?php else: ?>
                                <?php foreach ($customers as $customer): ?>
                                    <div class="customer-card">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <h5 class="mb-2"><?php echo $customer['nama_lengkap']; ?></h5>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <p class="mb-1"><strong>Pekerjaan:</strong> <?php echo $customer['pekerjaan'] ?: '-'; ?></p>
                                                        <p class="mb-1"><strong>Nomor HP:</strong> <?php echo $customer['nomor_hp']; ?></p>
                                                        <p class="mb-1"><strong>Email:</strong> <?php echo $customer['email'] ?: '-'; ?></p>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <p class="mb-1"><strong>NIK KTP:</strong> <?php echo $customer['nik_ktp']; ?></p>
                                                        <p class="mb-1"><strong>Dibuat oleh:</strong> <?php echo $customer['created_by_name']; ?></p>
                                                        <p class="mb-1"><strong>Tanggal Input:</strong> <?php echo formatDateTime($customer['created_at']); ?></p>
                                                    </div>
                                                </div>
                                                <p class="mb-0"><strong>Alamat:</strong> <?php echo $customer['alamat_lengkap']; ?></p>
                                                
                                                <!-- Foto KTP -->
                                                <?php if (!empty($customer['foto_ktp'])): ?>
                                                    <div class="mt-3">
                                                        <strong>Foto KTP:</strong><br>
                                                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                                                             alt="Foto KTP" class="img-thumbnail mt-2" 
                                                             style="max-width: 150px; max-height: 100px; cursor: pointer;"
                                                             data-bs-toggle="modal" data-bs-target="#photoModal<?php echo $customer['id']; ?>">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="col-md-4 text-end">
                                                <div class="mb-3">
                                                    <?php
                                                    $status_class = '';
                                                    $status_text = '';
                                                    switch ($customer['status']) {
                                                        case 'pending':
                                                            $status_class = 'warning';
                                                            $status_text = 'Menunggu Persetujuan';
                                                            break;
                                                        case 'approved':
                                                            $status_class = 'success';
                                                            $status_text = 'Disetujui';
                                                            break;
                                                        case 'rejected':
                                                            $status_class = 'danger';
                                                            $status_text = 'Ditolak';
                                                            break;
                                                    }
                                                    ?>
                                                    <span class="badge bg-<?php echo $status_class; ?> fs-6">
                                                        <?php echo $status_text; ?>
                                                    </span>
                                                </div>
                                                
                                                <div class="d-grid gap-2">
                                                    <?php if ($customer['status'] == 'pending'): ?>
                                                        <button type="button" class="btn btn-success btn-sm" 
                                                                data-bs-toggle="modal" data-bs-target="#approveModal<?php echo $customer['id']; ?>"
                                                                title="Setujui data pelanggan">
                                                            <i class="fas fa-check me-2"></i>Setujui
                                                        </button>
                                                        <button type="button" class="btn btn-danger btn-sm" 
                                                                data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo $customer['id']; ?>"
                                                                title="Tolak data pelanggan">
                                                            <i class="fas fa-times me-2"></i>Tolak
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <a href="customer_detail.php?id=<?php echo $customer['id']; ?>" 
                                                       class="btn btn-outline-info btn-sm" title="Lihat detail lengkap">
                                                        <i class="fas fa-eye me-2"></i>Detail
                                                    </a>
                                                    <a href="customer_edit_status.php?id=<?php echo $customer['id']; ?>" 
                                                       class="btn btn-outline-warning btn-sm" title="Edit Status">
                                                        <i class="fas fa-flag me-2"></i>Edit Status
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Modal Approve -->
                                    <div class="modal fade" id="approveModal<?php echo $customer['id']; ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Setujui Data Pelanggan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menyetujui data pelanggan <strong><?php echo $customer['nama_lengkap']; ?></strong>?</p>
                                                        <div class="mb-3">
                                                            <label for="notes_approve_<?php echo $customer['id']; ?>" class="form-label">Catatan (Opsional)</label>
                                                            <textarea class="form-control" id="notes_approve_<?php echo $customer['id']; ?>" 
                                                                      name="notes" rows="3" placeholder="Tambahkan catatan jika diperlukan..."></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-success">
                                                            <i class="fas fa-check me-2"></i>Setujui
                                                        </button>
                                                    </div>
                                                    <input type="hidden" name="action" value="approve">
                                                    <input type="hidden" name="customer_id" value="<?php echo $customer['id']; ?>">
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Modal Reject -->
                                    <div class="modal fade" id="rejectModal<?php echo $customer['id']; ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Tolak Data Pelanggan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST">
                                                    <div class="modal-body">
                                                        <p>Apakah Anda yakin ingin menolak data pelanggan <strong><?php echo $customer['nama_lengkap']; ?></strong>?</p>
                                                        <div class="mb-3">
                                                            <label for="notes_reject_<?php echo $customer['id']; ?>" class="form-label">Alasan Penolakan *</label>
                                                            <textarea class="form-control" id="notes_reject_<?php echo $customer['id']; ?>" 
                                                                      name="notes" rows="3" placeholder="Berikan alasan penolakan..." required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-danger">
                                                            <i class="fas fa-times me-2"></i>Tolak
                                                        </button>
                                                    </div>
                                                    <input type="hidden" name="action" value="reject">
                                                    <input type="hidden" name="customer_id" value="<?php echo $customer['id']; ?>">
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Modal Foto KTP -->
                                    <?php if (!empty($customer['foto_ktp'])): ?>
                                        <div class="modal fade" id="photoModal<?php echo $customer['id']; ?>" tabindex="-1">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Foto KTP - <?php echo $customer['nama_lengkap']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body text-center">
                                                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                                                             alt="Foto KTP" class="img-fluid" style="max-height: 70vh;">
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
