<?php
require_once 'config/config.php';
requireRole(['admin', 'supervisor']);

$database = new Database();
$db = $database->getConnection();

$customer_id = (int)($_GET['id'] ?? 0);

if (!$customer_id) {
    header('Location: customers.php');
    exit();
}

// Get customer data
$query = "SELECT c.*, u.full_name as created_by_name, u2.full_name as approved_by_name
          FROM customers c 
          LEFT JOIN users u ON c.created_by = u.id 
          LEFT JOIN users u2 ON c.approved_by = u2.id
          WHERE c.id = ?";
$stmt = $db->prepare($query);
$stmt->execute([$customer_id]);
$customer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$customer) {
    header('Location: customers.php');
    exit();
}

$success = '';
$error = '';

if ($_POST) {
    $new_status = sanitizeInput($_POST['status']);
    $notes = sanitizeInput($_POST['notes'] ?? '');
    
    // Validasi status
    $valid_statuses = ['pending', 'approved', 'rejected', 'installed', 'cancelled'];
    if (!in_array($new_status, $valid_statuses)) {
        $error = 'Status tidak valid!';
    } else {
        // Update status pelanggan
        $update_query = "UPDATE customers SET 
                        status = ?, 
                        approved_by = ?, 
                        approved_at = NOW(),
                        updated_at = NOW()
                        WHERE id = ?";
        $stmt = $db->prepare($update_query);
        
        if ($stmt->execute([$new_status, $_SESSION['user_id'], $customer_id])) {
            // Log aktivitas
            $log_query = "INSERT INTO activity_logs (user_id, action, description, table_name, record_id) VALUES (?, 'update', 'Mengubah status pelanggan menjadi: $new_status', 'customers', ?)";
            $log_stmt = $db->prepare($log_query);
            $log_stmt->execute([$_SESSION['user_id'], $customer_id]);
            
            $success = 'Status pelanggan berhasil diperbarui!';
            
            // Refresh customer data
            $query = "SELECT c.*, u.full_name as created_by_name, u2.full_name as approved_by_name
                      FROM customers c 
                      LEFT JOIN users u ON c.created_by = u.id 
                      LEFT JOIN users u2 ON c.approved_by = u2.id
                      WHERE c.id = ?";
            $stmt = $db->prepare($query);
            $stmt->execute([$customer_id]);
            $customer = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            $error = 'Gagal memperbarui status pelanggan!';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Status Pelanggan - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .sidebar .logo {
            padding: 1rem;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .logo i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.25rem 0.5rem;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            background: #f8f9fa;
            min-height: 100vh;
        }
        .header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .detail-card {
            background: white;
            border-radius: 0.5rem;
            padding: 2rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
            margin-bottom: 1.5rem;
        }
        .status-badge {
            font-size: 0.875rem;
            padding: 0.5rem 1rem;
        }
        .info-row {
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid #f8f9fa;
        }
        .info-label {
            font-weight: 600;
            color: #495057;
            min-width: 150px;
            display: inline-block;
        }
        .status-option {
            border: 2px solid #e9ecef;
            border-radius: 0.5rem;
            padding: 1rem;
            margin-bottom: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .status-option:hover {
            border-color: #667eea;
            background-color: #f8f9fa;
        }
        .status-option.selected {
            border-color: #667eea;
            background-color: #e3f2fd;
        }
        .status-option input[type="radio"] {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="logo">
                        <i class="fas fa-wifi"></i>
                        <h6 class="mb-0"><?php echo APP_NAME; ?></h6>
                        <small><?php echo APP_COMPANY; ?></small>
                    </div>
                    <nav class="nav flex-column mt-3">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link" href="customers.php">
                            <i class="fas fa-users me-2"></i>Data Pelanggan
                        </a>
                        <a class="nav-link" href="add_customer.php">
                            <i class="fas fa-user-plus me-2"></i>Tambah Pelanggan
                        </a>
                        <a class="nav-link" href="installed_customers.php">
                            <i class="fas fa-check-double me-2"></i>Selesai Instalasi
                        </a>
                        <a class="nav-link" href="reports.php">
                            <i class="fas fa-chart-bar me-2"></i>Laporan
                        </a>
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Header -->
                    <div class="header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">Edit Status Pelanggan</h4>
                            <div class="d-flex align-items-center">
                                <span class="me-3">Selamat datang, <?php echo $_SESSION['full_name']; ?></span>
                                <span class="badge bg-primary"><?php echo ucfirst($_SESSION['user_role']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content -->
                    <div class="p-4">
                        <?php if ($success): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i>
                                <?php echo $success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo $error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Detail Pelanggan -->
                        <div class="detail-card">
                            <h5 class="mb-4">Detail Pelanggan</h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-row">
                                        <span class="info-label">Nama Lengkap:</span>
                                        <span><?php echo $customer['nama_lengkap']; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Pekerjaan:</span>
                                        <span><?php echo $customer['pekerjaan'] ?: '-'; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Nomor HP:</span>
                                        <span><?php echo $customer['nomor_hp']; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Email:</span>
                                        <span><?php echo $customer['email'] ?: '-'; ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-row">
                                        <span class="info-label">NIK KTP:</span>
                                        <span><?php echo $customer['nik_ktp']; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Dibuat Oleh:</span>
                                        <span><?php echo $customer['created_by_name']; ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Tanggal Input:</span>
                                        <span><?php echo formatDateTime($customer['created_at']); ?></span>
                                    </div>
                                    <?php if ($customer['approved_at']): ?>
                                    <div class="info-row">
                                        <span class="info-label">Tanggal Disetujui:</span>
                                        <span><?php echo formatDateTime($customer['approved_at']); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="info-row">
                                <span class="info-label">Alamat Lengkap:</span>
                                <div class="mt-2">
                                    <?php echo nl2br($customer['alamat_lengkap']); ?>
                                </div>
                            </div>
                            
                            <!-- Foto KTP -->
                            <?php if (!empty($customer['foto_ktp'])): ?>
                                <div class="info-row">
                                    <span class="info-label">Foto KTP:</span>
                                    <div class="mt-2">
                                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                                             alt="Foto KTP" class="img-thumbnail" 
                                             style="max-width: 200px; max-height: 150px; cursor: pointer;"
                                             data-bs-toggle="modal" data-bs-target="#photoModal">
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Form Edit Status -->
                        <div class="detail-card">
                            <h5 class="mb-4">Edit Status Pelanggan</h5>
                            
                            <form method="POST">
                                <div class="mb-4">
                                    <label class="form-label fw-bold">Status Saat Ini:</label>
                                    <div class="mt-2">
                                        <?php
                                        $status_class = '';
                                        $status_text = '';
                                        switch ($customer['status']) {
                                            case 'pending':
                                                $status_class = 'warning';
                                                $status_text = 'Pending';
                                                break;
                                            case 'approved':
                                                $status_class = 'info';
                                                $status_text = 'Approved';
                                                break;
                                            case 'installed':
                                                $status_class = 'success';
                                                $status_text = 'Installed';
                                                break;
                                            case 'cancelled':
                                                $status_class = 'danger';
                                                $status_text = 'Cancelled';
                                                break;
                                            case 'rejected':
                                                $status_class = 'secondary';
                                                $status_text = 'Rejected';
                                                break;
                                        }
                                        ?>
                                        <span class="badge bg-<?php echo $status_class; ?> status-badge">
                                            <?php echo $status_text; ?>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <label class="form-label fw-bold">Pilih Status Baru:</label>
                                    <div class="mt-3">
                                        <div class="status-option <?php echo $customer['status'] == 'pending' ? 'selected' : ''; ?>">
                                            <input type="radio" name="status" value="pending" id="status_pending" 
                                                   <?php echo $customer['status'] == 'pending' ? 'checked' : ''; ?>>
                                            <label for="status_pending" class="mb-0">
                                                <i class="fas fa-clock text-warning me-2"></i>
                                                <strong>Pending</strong> - Menunggu persetujuan
                                            </label>
                                        </div>
                                        
                                        <div class="status-option <?php echo $customer['status'] == 'approved' ? 'selected' : ''; ?>">
                                            <input type="radio" name="status" value="approved" id="status_approved" 
                                                   <?php echo $customer['status'] == 'approved' ? 'checked' : ''; ?>>
                                            <label for="status_approved" class="mb-0">
                                                <i class="fas fa-check text-info me-2"></i>
                                                <strong>Approved</strong> - Disetujui, siap instalasi
                                            </label>
                                        </div>
                                        
                                        <div class="status-option <?php echo $customer['status'] == 'installed' ? 'selected' : ''; ?>">
                                            <input type="radio" name="status" value="installed" id="status_installed" 
                                                   <?php echo $customer['status'] == 'installed' ? 'checked' : ''; ?>>
                                            <label for="status_installed" class="mb-0">
                                                <i class="fas fa-check-double text-success me-2"></i>
                                                <strong>Installed</strong> - Sudah terinstalasi
                                            </label>
                                        </div>
                                        
                                        <div class="status-option <?php echo $customer['status'] == 'rejected' ? 'selected' : ''; ?>">
                                            <input type="radio" name="status" value="rejected" id="status_rejected" 
                                                   <?php echo $customer['status'] == 'rejected' ? 'checked' : ''; ?>>
                                            <label for="status_rejected" class="mb-0">
                                                <i class="fas fa-times text-secondary me-2"></i>
                                                <strong>Rejected</strong> - Ditolak
                                            </label>
                                        </div>
                                        
                                        <div class="status-option <?php echo $customer['status'] == 'cancelled' ? 'selected' : ''; ?>">
                                            <input type="radio" name="status" value="cancelled" id="status_cancelled" 
                                                   <?php echo $customer['status'] == 'cancelled' ? 'checked' : ''; ?>>
                                            <label for="status_cancelled" class="mb-0">
                                                <i class="fas fa-ban text-danger me-2"></i>
                                                <strong>Cancelled</strong> - Dibatalkan
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <label for="notes" class="form-label fw-bold">Catatan (Opsional):</label>
                                    <textarea class="form-control" id="notes" name="notes" rows="3" 
                                              placeholder="Tambahkan catatan untuk perubahan status ini..."></textarea>
                                </div>
                                
                                <div class="d-flex justify-content-between">
                                    <a href="customers.php" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left me-2"></i>Kembali
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-2"></i>Simpan Perubahan Status
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Foto KTP -->
    <?php if (!empty($customer['foto_ktp'])): ?>
        <div class="modal fade" id="photoModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Foto KTP - <?php echo $customer['nama_lengkap']; ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <img src="uploads/ktp/<?php echo $customer['foto_ktp']; ?>" 
                             alt="Foto KTP" class="img-fluid" style="max-height: 70vh;">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Handle status option selection
        document.querySelectorAll('.status-option').forEach(option => {
            option.addEventListener('click', function() {
                // Remove selected class from all options
                document.querySelectorAll('.status-option').forEach(opt => opt.classList.remove('selected'));
                // Add selected class to clicked option
                this.classList.add('selected');
                // Check the radio button
                this.querySelector('input[type="radio"]').checked = true;
            });
        });
        
        // Handle radio button change
        document.querySelectorAll('input[name="status"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Remove selected class from all options
                document.querySelectorAll('.status-option').forEach(opt => opt.classList.remove('selected'));
                // Add selected class to parent option
                this.closest('.status-option').classList.add('selected');
            });
        });
    </script>
</body>
</html>

